/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import generic.util.ChannelLocker;
import generic.util.FileChannelLock;
import generic.util.FileLocker;
import java.io.File;

public class LockFactory {
    private static Boolean supportsChannelLocking;

    public static FileLocker createFileLocker(File lockFile) {
        if (LockFactory.supportsChannelLocking(lockFile.getParentFile())) {
            return new ChannelLocker(lockFile);
        }
        return new FileLocker(lockFile);
    }

    private static boolean supportsChannelLocking(File testDir) {
        if (supportsChannelLocking == null) {
            File testFile = LockFactory.createTestFile(testDir);
            FileChannelLock channelLock = new FileChannelLock(testFile);
            boolean canLock = channelLock.lock();
            channelLock.release();
            supportsChannelLocking = canLock;
        }
        return supportsChannelLocking;
    }

    private static File createTestFile(File directory) {
        return new File(directory, ".ghidra.test.lock~");
    }
}

