/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Accumulator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class SizeLimitedAccumulatorWrapper<T>
implements Accumulator<T> {
    private Accumulator<T> accumulator;
    private int maxSize;

    public SizeLimitedAccumulatorWrapper(Accumulator<T> accumulator, int maxSize) {
        this.accumulator = Objects.requireNonNull(accumulator);
        this.maxSize = maxSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.accumulator.iterator();
    }

    @Override
    public void add(T t) {
        this.accumulator.add(t);
    }

    @Override
    public void addAll(Collection<T> collection) {
        this.accumulator.addAll(collection);
    }

    @Override
    public boolean contains(T t) {
        return this.accumulator.contains(t);
    }

    @Override
    public Collection<T> get() {
        return this.accumulator.get();
    }

    @Override
    public int size() {
        return this.accumulator.size();
    }

    public boolean hasReachedSizeLimit() {
        return this.accumulator.size() >= this.maxSize;
    }
}

