/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.ThemeValue;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractThemeReader {
    private static final String NO_SECTION = "No Section";
    private static final String DEFAULTS = "Defaults";
    private static final String DARK_DEFAULTS = "Dark Defaults";
    private List<String> errors = new ArrayList<String>();
    protected String source;

    protected AbstractThemeReader(String source) {
        this.source = source;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected void read(Reader reader) throws IOException {
        List<Section> sections = this.readSections(new LineNumberReader(reader));
        block10: for (Section section : sections) {
            switch (section.getName()) {
                case "No Section": {
                    this.processNoSection(section);
                    continue block10;
                }
                case "Defaults": {
                    this.processDefaultSection(section);
                    continue block10;
                }
                case "Dark Defaults": {
                    this.processDarkDefaultSection(section);
                    continue block10;
                }
            }
            this.processCustomSection(section);
        }
    }

    protected abstract void processNoSection(Section var1) throws IOException;

    protected abstract void processDefaultSection(Section var1) throws IOException;

    protected abstract void processDarkDefaultSection(Section var1) throws IOException;

    protected abstract void processCustomSection(Section var1) throws IOException;

    protected void processValues(GThemeValueMap valueMap, Section section) {
        for (String key : section.getKeys()) {
            ThemeValue oldValue;
            String value = section.getValue(key);
            int lineNumber = section.getLineNumber(key);
            if (ColorValue.isColorKey(key)) {
                ColorValue colorValue = this.parseColorProperty(key, value, lineNumber);
                ColorValue oldValue2 = valueMap.addColor(colorValue);
                this.reportDuplicateKey(oldValue2, lineNumber);
                continue;
            }
            if (FontValue.isFontKey(key)) {
                oldValue = valueMap.addFont(this.parseFontProperty(key, value, lineNumber));
                this.reportDuplicateKey(oldValue, lineNumber);
                continue;
            }
            if (IconValue.isIconKey(key)) {
                if ("<JAVA ICON>".equals(value)) continue;
                oldValue = valueMap.addIcon(this.parseIconProperty(key, value, lineNumber));
                this.reportDuplicateKey(oldValue, lineNumber);
                continue;
            }
            this.error(lineNumber, "Can't process property: " + key + " = " + value);
        }
    }

    private void reportDuplicateKey(ThemeValue<?> oldValue, int lineNumber) {
        if (oldValue != null) {
            this.error(lineNumber, "Duplicate id found: \"" + oldValue.getId() + "\"");
        }
    }

    private IconValue parseIconProperty(String key, String value, int lineNumber) {
        try {
            IconValue parsedValue = IconValue.parse(key, value);
            if (parsedValue == null) {
                this.error(lineNumber, "Could not parse Icon value: " + value);
            }
            return parsedValue;
        }
        catch (ParseException e) {
            this.error(lineNumber, "Could not parse Icon value: \"" + value + "\" because: " + e.getMessage());
            return null;
        }
    }

    private FontValue parseFontProperty(String key, String value, int lineNumber) {
        try {
            FontValue parsedValue = FontValue.parse(key, value);
            if (parsedValue == null) {
                this.error(lineNumber, "Could not parse Font value: " + value);
            }
            return parsedValue;
        }
        catch (Exception e) {
            this.error(lineNumber, "Could not parse Font value: " + value + "because " + e.getMessage());
            return null;
        }
    }

    private ColorValue parseColorProperty(String key, String value, int lineNumber) {
        ColorValue parsedValue = ColorValue.parse(key, value);
        if (parsedValue == null) {
            this.error(lineNumber, "Could not parse Color value: " + value);
        }
        return parsedValue;
    }

    private List<Section> readSections(LineNumberReader reader) throws IOException {
        String line;
        ArrayList<Section> sections = new ArrayList<Section>();
        Section currentSection = new Section(NO_SECTION, 0);
        sections.add(currentSection);
        while ((line = reader.readLine()) != null) {
            if ((line = this.removeComments(line)).isBlank()) continue;
            if (this.isSectionHeader(line)) {
                String name = line.substring(1, line.length() - 1);
                currentSection = new Section(name, reader.getLineNumber());
                sections.add(currentSection);
                continue;
            }
            currentSection.add(line, reader.getLineNumber());
        }
        return sections;
    }

    private String removeComments(String line) {
        int commentIndex = line.indexOf("//");
        if (commentIndex >= 0) {
            line = line.substring(0, commentIndex);
        }
        if ((line = line.trim()).startsWith("#")) {
            return "";
        }
        return line;
    }

    private boolean isSectionHeader(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    protected void error(int lineNumber, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error parsing theme file \"" + this.source + "\"");
        if (lineNumber >= 0) {
            builder.append(" at line: " + lineNumber);
        }
        builder.append(". ");
        builder.append(message);
        String msg = builder.toString();
        this.errors.add(msg);
        this.outputError(msg);
    }

    protected void outputError(String msg) {
        Msg.error((Object)this, (Object)msg);
    }

    protected class Section {
        private String name;
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<String, Integer> lineNumbers = new HashMap<String, Integer>();
        private int startLineNumber;

        public Section(String sectionName, int lineNumber) {
            this.name = sectionName;
            this.startLineNumber = lineNumber;
        }

        public void remove(String key) {
            this.properties.remove(key);
        }

        public String getValue(String key) {
            return this.properties.get(key);
        }

        public Set<String> getKeys() {
            return this.properties.keySet();
        }

        public int getLineNumber(String key) {
            return this.lineNumbers.get(key);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public int getLineNumber() {
            return this.startLineNumber;
        }

        public String getName() {
            return this.name;
        }

        public void add(String line, int lineNumber) {
            int splitIndex = line.indexOf(61);
            if (splitIndex < 0) {
                AbstractThemeReader.this.error(lineNumber, "Missing required \"=\" for propery line: \"" + line + "\"");
                return;
            }
            String key = line.substring(0, splitIndex).trim();
            String value = line.substring(splitIndex + 1, line.length()).trim();
            if (key.isBlank()) {
                AbstractThemeReader.this.error(lineNumber, "Missing key for propery line: \"" + line + "\"");
                return;
            }
            if (value.isBlank()) {
                AbstractThemeReader.this.error(lineNumber, "Missing value for propery line: \"" + line + "\"");
                return;
            }
            if (this.properties.containsKey(key)) {
                AbstractThemeReader.this.error(lineNumber, "Duplicate key found in this file!: \"" + key + "\"");
                return;
            }
            this.properties.put(key, value);
            this.lineNumbers.put(key, lineNumber);
        }
    }
}

