/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GColorUIResource;
import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.laf.FontNonUiResource;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.apache.commons.collections4.IteratorUtils;

public class UiDefaultsMapper {
    public static final String LAF_COLOR_ID_PREFIX = "laf.color.";
    public static final String LAF_FONT_ID_PREFIX = "laf.font.";
    public static final String LAF_ICON_ID_PREFIX = "laf.icon.";
    private static final String LAF_COLOR_PALETTE_PREFIX = "laf.palette.color.";
    private static final String LAF_FONT_PALETTE_PREFIX = "laf.palette.font.";
    private static final String[] MENU_COMPONENTS = new String[]{"Menu", "MenuBar", "MenuItem", "PopupMenu", "RadioButtonMenuItem", "CheckBoxMenuItem"};
    private static final String[] VIEW_COMPONENTS = new String[]{"FileChooser", "ColorChooser", "ComboBox", "List", "Table", "Tree", "TextField", "FormattedTextField", "PasswordField", "TextArea", "TextPane", "EditorPane"};
    private static final String[] TOOLTIP_COMPONENTS = new String[]{"ToolTip"};
    protected UIDefaults defaults;
    private GThemeValueMap extractedValues;
    private GThemeValueMap normalizedValues = new GThemeValueMap();
    private Map<String, String> lafIdToNormalizedIdMap = new HashMap<String, String>();
    protected Set<String> ignoredLafIds = new HashSet<String>();
    private Map<String, ColorMatcher> componentToColorMatcherMap = new HashMap<String, ColorMatcher>();
    private Map<String, FontMatcher> componentToFontMatcherMap = new HashMap<String, FontMatcher>();
    protected ColorMatcher viewColorMatcher = new ColorMatcher("system.color.bg.view", "system.color.fg.view", "system.color.bg.selected.view", "system.color.fg.selected.view");
    protected ColorMatcher tooltipColorMatcher = new ColorMatcher("system.color.bg.tooltip", "system.color.fg.tooltip");
    protected ColorMatcher defaultColorMatcher = new ColorMatcher("system.color.bg.control", "system.color.fg.control", "system.color.bg.view", "system.color.fg.view", "system.color.fg.disabled", "system.color.bg.selected.view", "system.color.fg.selected.view", "system.color.bg.tooltip", "system.color.bg.border");
    protected FontMatcher menuFontMatcher = new FontMatcher("system.font.menu");
    protected FontMatcher viewFontMatcher = new FontMatcher("system.font.view");
    protected FontMatcher defaultFontMatcher = new FontMatcher("system.font.control", "system.font.view", "system.font.menu");
    private Map<Color, String> lafColorPaletteMap = new HashMap<Color, String>();
    private Map<Font, String> lafFontPaletteMap = new HashMap<Font, String>();
    private int nextColorPaletteId;
    private int nextFontPaletteId;

    protected UiDefaultsMapper(UIDefaults defaults) {
        this.defaults = defaults;
        this.extractedValues = this.extractColorFontAndIconValuesFromDefaults();
        this.assignSystemColorValues();
        this.assignSystemFontValues();
        this.registerIgnoredLafIds();
        this.assignColorMatchersToComponentIds();
        this.assignFontMatchersToComponentIds();
        this.assignNormalizedColorValues();
        this.assignNormalizedFontValues();
        this.assignNormalizedIconValues();
    }

    public GThemeValueMap getJavaDefaults() {
        return this.normalizedValues;
    }

    public void installValuesIntoUIDefaults(GThemeValueMap currentValues) {
        this.installGColorsIntoUIDefaults();
        this.installOverriddenFontsIntoUIDefaults(currentValues);
        this.installOverriddenIconsIntoUIDefaults(currentValues);
    }

    public Map<String, String> getNormalizedIdToLafIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.lafIdToNormalizedIdMap.entrySet()) {
            String lafId = entry.getKey();
            String standardId = entry.getValue();
            map.put(standardId, lafId);
        }
        return map;
    }

    protected void registerIgnoredLafIds() {
        this.ignoredLafIds.add("desktop");
        this.ignoredLafIds.add("activeCaption");
        this.ignoredLafIds.add("activeCaptionText");
        this.ignoredLafIds.add("activeCaptionBorder");
        this.ignoredLafIds.add("inactiveCaption");
        this.ignoredLafIds.add("inactiveCaptionText");
        this.ignoredLafIds.add("inactiveCaptionBorder");
        this.ignoredLafIds.add("window");
        this.ignoredLafIds.add("windowBorder");
        this.ignoredLafIds.add("windowText");
        this.ignoredLafIds.add("menu");
        this.ignoredLafIds.add("menuText");
        this.ignoredLafIds.add("text");
        this.ignoredLafIds.add("textText");
        this.ignoredLafIds.add("textHighlight");
        this.ignoredLafIds.add("textHighightText");
        this.ignoredLafIds.add("textInactiveText");
        this.ignoredLafIds.add("control");
        this.ignoredLafIds.add("controlText");
        this.ignoredLafIds.add("controlHighlight");
        this.ignoredLafIds.add("controlLtHighlight");
        this.ignoredLafIds.add("controlShadow");
        this.ignoredLafIds.add("controlDkShadow");
        this.ignoredLafIds.add("info");
        this.ignoredLafIds.add("infoText");
        this.ignoredLafIds.add("scrollbar");
    }

    protected void assignSystemColorValues() {
        this.assignSystemColorFromLafId("system.color.bg.control", "Button.background");
        this.assignSystemColorFromLafId("system.color.fg.control", "Button.foreground");
        this.assignSystemColorFromLafId("system.color.bg.border", "InternalFrame.borderColor");
        this.assignSystemColorFromLafId("system.color.bg.view", "TextArea.background");
        this.assignSystemColorFromLafId("system.color.fg.view", "TextArea.foreground");
        this.assignSystemColorFromLafId("system.color.bg.selected.view", "TextArea.selectionBackground");
        this.assignSystemColorFromLafId("system.color.fg.selected.view", "TextArea.selectionForeground");
        this.assignSystemColorFromLafId("system.color.fg.disabled", "Label.disabledForeground");
        this.assignSystemColorFromLafId("system.color.bg.tooltip", "ToolTip.background");
        this.assignSystemColorFromLafId("system.color.fg.tooltip", "ToolTip.foreground");
    }

    protected void assignSystemColorFromLafId(String systemColorId, String lafId) {
        Color lafColor = this.defaults.getColor(lafId);
        if (lafColor == null) {
            Msg.debug((Object)this, (Object)("Missing value for system color: \"" + systemColorId + "\". No value for laf id: \"" + lafId + "\"."));
            return;
        }
        this.normalizedValues.addColor(new ColorValue(systemColorId, lafColor));
    }

    protected void assignSystemColorDirect(String systemColorId, Color color) {
        this.normalizedValues.addColor(new ColorValue(systemColorId, color));
    }

    protected void assignSystemFontDirect(String systemFontId, Font font) {
        this.normalizedValues.addFont(new FontValue(systemFontId, font));
    }

    protected void assignSystemFontValues() {
        this.assignSystemFontFromLafId("system.font.control", "Button.font");
        this.assignSystemFontFromLafId("system.font.view", "Table.font");
        this.assignSystemFontFromLafId("system.font.menu", "Menu.font");
    }

    private void assignSystemFontFromLafId(String systemFontId, String lafId) {
        Font lafFont = this.extractedValues.getResolvedFont(lafId);
        if (lafFont == null) {
            Msg.debug((Object)this, (Object)("Missing value for system font: \"" + systemFontId + "\". No value for laf id: \"" + lafId + "\"."));
            return;
        }
        this.normalizedValues.addFont(new FontValue(systemFontId, this.fromUiResource(lafFont)));
    }

    protected void assignFontMatchersToComponentIds() {
        this.defineComponentFontMatcher(MENU_COMPONENTS, this.menuFontMatcher);
        this.defineComponentFontMatcher(VIEW_COMPONENTS, this.viewFontMatcher);
    }

    protected void assignColorMatchersToComponentIds() {
        this.defineComponentColorMatcher(VIEW_COMPONENTS, this.viewColorMatcher);
        this.defineComponentColorMatcher(TOOLTIP_COMPONENTS, this.tooltipColorMatcher);
    }

    private void defineComponentColorMatcher(String[] componentGroups, ColorMatcher matcher) {
        for (String componentGroup : componentGroups) {
            this.componentToColorMatcherMap.put(componentGroup, matcher);
        }
    }

    private void defineComponentFontMatcher(String[] componentGroups, FontMatcher matcher) {
        for (String componentGroup : componentGroups) {
            this.componentToFontMatcherMap.put(componentGroup, matcher);
        }
    }

    private void assignNormalizedFontValues() {
        ArrayList<String> list = new ArrayList<String>(this.extractedValues.getFontIds());
        Collections.sort(list);
        for (String lafId : list) {
            if (this.ignoredLafIds.contains(lafId)) continue;
            String createdId = LAF_FONT_ID_PREFIX + lafId;
            this.lafIdToNormalizedIdMap.put(lafId, createdId);
            Font lafFont = this.extractedValues.getResolvedFont(lafId);
            FontValue fontValue = this.getFontValue(createdId, lafId, lafFont);
            this.normalizedValues.addFont(fontValue);
        }
    }

    private void assignNormalizedIconValues() {
        for (String lafId : this.extractedValues.getIconIds()) {
            String createdId = LAF_ICON_ID_PREFIX + lafId;
            Icon icon = this.extractedValues.getResolvedIcon(lafId);
            if (icon == null) continue;
            this.normalizedValues.addIcon(new IconValue(createdId, icon));
            this.lafIdToNormalizedIdMap.put(lafId, createdId);
        }
    }

    protected void assignNormalizedColorValues() {
        ArrayList<String> list = new ArrayList<String>(this.extractedValues.getColorIds());
        Collections.sort(list);
        for (String lafId : list) {
            if (this.ignoredLafIds.contains(lafId)) continue;
            String createdId = LAF_COLOR_ID_PREFIX + lafId;
            this.lafIdToNormalizedIdMap.put(lafId, createdId);
            Color lafColor = this.extractedValues.getResolvedColor(lafId);
            ColorValue colorValue = this.getColorValue(createdId, lafId, lafColor);
            this.normalizedValues.addColor(colorValue);
        }
    }

    private ColorValue getColorValue(String id, String lafId, Color lafColor) {
        String systemId = this.findSystemColorId(lafId, lafColor);
        if (systemId == null) {
            systemId = this.getColorPaletteId(lafColor);
        }
        return new ColorValue(id, systemId);
    }

    private FontValue getFontValue(String id, String lafId, Font lafFont) {
        String systemFontId = this.findSystemFontId(lafId, lafFont);
        if (systemFontId == null) {
            systemFontId = this.getFontPaletteId(lafFont);
        }
        return new FontValue(id, systemFontId);
    }

    private String getColorPaletteId(Color lafColor) {
        String paletteId = this.lafColorPaletteMap.get(lafColor);
        if (paletteId == null) {
            ++this.nextColorPaletteId;
            paletteId = String.format("%s%02d", LAF_COLOR_PALETTE_PREFIX, this.nextColorPaletteId);
            this.lafColorPaletteMap.put(lafColor, paletteId);
            this.normalizedValues.addColor(new ColorValue(paletteId, lafColor));
        }
        return paletteId;
    }

    private String getFontPaletteId(Font lafFont) {
        String paletteId = this.lafFontPaletteMap.get(lafFont);
        if (paletteId == null) {
            ++this.nextFontPaletteId;
            paletteId = String.format("%s%02d", LAF_FONT_PALETTE_PREFIX, this.nextFontPaletteId);
            this.lafFontPaletteMap.put(lafFont, paletteId);
            this.normalizedValues.addFont(new FontValue(paletteId, lafFont));
        }
        return paletteId;
    }

    private String findSystemColorId(String lafId, Color lafColor) {
        String systemId;
        String componentName = this.getComponentName(lafId);
        ColorMatcher colorMatcher = this.componentToColorMatcherMap.get(componentName);
        if (colorMatcher != null && (systemId = colorMatcher.getSystemId(lafColor)) != null) {
            return systemId;
        }
        return this.defaultColorMatcher.getSystemId(lafColor);
    }

    private String findSystemFontId(String lafId, Font lafFont) {
        String systemId;
        String componentName = this.getComponentName(lafId);
        FontMatcher fontMatcher = this.componentToFontMatcherMap.get(componentName);
        if (fontMatcher != null && (systemId = fontMatcher.getSystemId(lafFont)) != null) {
            return systemId;
        }
        return this.defaultFontMatcher.getSystemId(lafFont);
    }

    private String getComponentName(String lafId) {
        int dotIndex = lafId.indexOf(".");
        if (dotIndex < 0) {
            return lafId;
        }
        return lafId.substring(0, dotIndex);
    }

    protected void installGColorsIntoUIDefaults() {
        HashMap<String, GColorUIResource> cachedColors = new HashMap<String, GColorUIResource>();
        for (String lafId : this.extractedValues.getColorIds()) {
            String standardColorId = this.lafIdToNormalizedIdMap.get(lafId);
            if (standardColorId == null) continue;
            GColorUIResource sharedGColor = this.getSharedGColor(cachedColors, standardColorId);
            this.defaults.put(lafId, sharedGColor);
        }
    }

    private void installOverriddenIconsIntoUIDefaults(GThemeValueMap currentValues) {
        for (String lafId : this.extractedValues.getIconIds()) {
            Icon currentIcon = this.extractedValues.getResolvedIcon(lafId);
            String standardId = this.lafIdToNormalizedIdMap.get(lafId);
            Icon overriddenIcon = currentValues.getResolvedIcon(standardId);
            if (overriddenIcon == null || currentIcon == overriddenIcon) continue;
            this.defaults.put(lafId, overriddenIcon);
        }
    }

    private void installOverriddenFontsIntoUIDefaults(GThemeValueMap currentValues) {
        for (String lafId : this.extractedValues.getFontIds()) {
            Font currentFont = this.extractedValues.getResolvedFont(lafId);
            String standardId = this.lafIdToNormalizedIdMap.get(lafId);
            Font overriddenFont = currentValues.getResolvedFont(standardId);
            if (overriddenFont == null || overriddenFont == currentFont) continue;
            this.defaults.put(lafId, new FontUIResource(overriddenFont));
        }
    }

    private GColorUIResource getSharedGColor(Map<String, GColorUIResource> cache, String id) {
        GColorUIResource gColor = cache.get(id);
        if (gColor == null) {
            gColor = new GColorUIResource(id);
            cache.put(id, gColor);
        }
        return gColor;
    }

    protected void overrideColor(String lafId, String sytemId) {
        String normalizedId = this.lafIdToNormalizedIdMap.get(lafId);
        if (normalizedId == null) {
            Msg.debug((Object)this, (Object)("Missing value for laf id: \"" + lafId));
            return;
        }
        this.normalizedValues.addColor(new ColorValue(normalizedId, sytemId));
    }

    protected GThemeValueMap extractColorFontAndIconValuesFromDefaults() {
        GThemeValueMap values = new GThemeValueMap();
        List<String> ids = this.getLookAndFeelIdsForType(Color.class);
        for (String id : ids) {
            values.addColor(new ColorValue(id, this.defaults.getColor(id)));
        }
        ids = this.getLookAndFeelIdsForType(Font.class);
        for (String id : ids) {
            values.addFont(new FontValue(id, this.defaults.getFont(id)));
        }
        ids = this.getLookAndFeelIdsForType(Icon.class);
        for (String id : ids) {
            Icon icon = this.defaults.getIcon(id);
            values.addIcon(new IconValue(id, icon));
        }
        return values;
    }

    private Font fromUiResource(Font font) {
        if (font instanceof UIResource) {
            return new FontNonUiResource(font);
        }
        return font;
    }

    private List<String> getLookAndFeelIdsForType(Class<?> clazz) {
        ArrayList<String> colorKeys = new ArrayList<String>();
        List keyList = IteratorUtils.toList(this.defaults.keys().asIterator());
        for (Object key : keyList) {
            Object value;
            if (!(key instanceof String) || !clazz.isInstance(value = this.defaults.get(key))) continue;
            colorKeys.add((String)key);
        }
        return colorKeys;
    }

    private class ColorMatcher
    extends ValueMatcher<Color> {
        ColorMatcher(String ... systemIds) {
            super(systemIds);
        }

        @Override
        protected Color getValueFromJavaDefaults(String systemId) {
            return UiDefaultsMapper.this.normalizedValues.getResolvedColor(systemId);
        }
    }

    private class FontMatcher
    extends ValueMatcher<Font> {
        FontMatcher(String ... systemIds) {
            super(systemIds);
        }

        @Override
        protected Font getValueFromJavaDefaults(String systemId) {
            return UiDefaultsMapper.this.normalizedValues.getResolvedFont(systemId);
        }
    }

    private abstract class ValueMatcher<T> {
        private Map<T, String> map = new HashMap<T, String>();
        private List<String> systemIdList;
        private boolean initialized;

        ValueMatcher(String ... systemIds) {
            this.systemIdList = new ArrayList<String>(Arrays.asList(systemIds));
        }

        private void initialize() {
            this.initialized = true;
            for (int i = this.systemIdList.size() - 1; i >= 0; --i) {
                String systemId = this.systemIdList.get(i);
                T value = this.getValueFromJavaDefaults(systemId);
                if (value == null) continue;
                this.map.put(value, systemId);
            }
        }

        protected abstract T getValueFromJavaDefaults(String var1);

        String getSystemId(T value) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.map.get(value);
        }
    }
}

