/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class AsyncPairingCache<K, V> {
    private final Map<K, V> results;
    private final Map<K, V> resultsView;
    private final Map<K, CompletableFuture<V>> promises;
    private final Map<K, CompletableFuture<V>> promisesView;

    public AsyncPairingCache(int maxPending) {
        this.results = this.createResultCache(maxPending);
        this.resultsView = Collections.unmodifiableMap(this.results);
        this.promises = this.createPromiseCache(maxPending);
        this.promisesView = Collections.unmodifiableMap(this.promises);
    }

    protected abstract Map<K, V> createResultCache(int var1);

    protected abstract Map<K, CompletableFuture<V>> createPromiseCache(int var1);

    public CompletableFuture<V> waitOn(K key) {
        return this.waitOn(key, k -> new CompletableFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<V> waitOn(K key, Function<K, CompletableFuture<V>> futureFactory) {
        V value;
        AsyncPairingCache asyncPairingCache = this;
        synchronized (asyncPairingCache) {
            value = this.results.remove(key);
            if (value == null) {
                return this.promises.computeIfAbsent(key, futureFactory);
            }
        }
        CompletableFuture<V> future = futureFactory.apply(key);
        future.complete(value);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fulfill(K key, V value) {
        CompletableFuture<V> promise;
        AsyncPairingCache asyncPairingCache = this;
        synchronized (asyncPairingCache) {
            promise = this.promises.remove(key);
            if (promise == null) {
                this.results.put(key, value);
                return;
            }
        }
        promise.complete(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Throwable exc) {
        HashSet<CompletableFuture<V>> copy = new HashSet<CompletableFuture<V>>();
        AsyncPairingCache asyncPairingCache = this;
        synchronized (asyncPairingCache) {
            copy.addAll(this.promises.values());
            this.promises.clear();
            this.results.clear();
        }
        for (CompletableFuture completableFuture : copy) {
            completableFuture.completeExceptionally(exc);
        }
    }

    public Map<K, CompletableFuture<V>> getUnpairedPromises() {
        return this.promisesView;
    }

    public Map<K, V> getUnpairedResults() {
        return this.resultsView;
    }
}

