/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.PcodeOp;
import java.math.BigInteger;

public interface PcodeArithmetic<T> {
    public static final int SIZEOF_SIZEOF = 8;

    public Endian getEndian();

    public T unaryOp(int var1, int var2, int var3, T var4);

    default public T unaryOp(PcodeOp op, T in1) {
        return this.unaryOp(op.getOpcode(), op.getOutput().getSize(), op.getInput(0).getSize(), in1);
    }

    public T binaryOp(int var1, int var2, int var3, T var4, int var5, T var6);

    default public T binaryOp(PcodeOp op, T in1, T in2) {
        return this.binaryOp(op.getOpcode(), op.getOutput().getSize(), op.getInput(0).getSize(), in1, op.getInput(1).getSize(), in2);
    }

    default public T ptrAdd(int sizeout, int sizeinBase, T inBase, int sizeinIndex, T inIndex, int inSize) {
        T indexSized = this.binaryOp(32, sizeout, sizeinIndex, inIndex, 4, this.fromConst(inSize, 4));
        return this.binaryOp(19, sizeout, sizeinBase, inBase, sizeout, indexSized);
    }

    default public T ptrSub(int sizeout, int sizeinBase, T inBase, int sizeinOffset, T inOffset) {
        return this.binaryOp(19, sizeout, sizeinBase, inBase, sizeinOffset, inOffset);
    }

    public T modBeforeStore(int var1, int var2, T var3, int var4, T var5);

    public T modAfterLoad(int var1, int var2, T var3, int var4, T var5);

    public T fromConst(byte[] var1);

    default public T fromConst(long value, int size) {
        return this.fromConst(Utils.longToBytes((long)value, (int)size, (boolean)this.getEndian().isBigEndian()));
    }

    default public T fromConst(BigInteger value, int size, boolean isContextreg) {
        return this.fromConst(Utils.bigIntegerToBytes((BigInteger)value, (int)size, (isContextreg || this.getEndian().isBigEndian() ? 1 : 0) != 0));
    }

    default public T fromConst(BigInteger value, int size) {
        return this.fromConst(value, size, false);
    }

    public byte[] toConcrete(T var1, Purpose var2);

    default public boolean isTrue(T cond, Purpose purpose) {
        byte[] concrete;
        for (byte b : concrete = this.toConcrete(cond, purpose)) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    default public BigInteger toBigInteger(T value, Purpose purpose) {
        byte[] concrete = this.toConcrete(value, purpose);
        return Utils.bytesToBigInteger((byte[])concrete, (int)concrete.length, (purpose == Purpose.CONTEXT || this.getEndian().isBigEndian() ? 1 : 0) != 0, (boolean)false);
    }

    default public long toLong(T value, Purpose purpose) {
        byte[] concrete = this.toConcrete(value, purpose);
        return Utils.bytesToLong((byte[])concrete, (int)concrete.length, (purpose == Purpose.CONTEXT || this.getEndian().isBigEndian() ? 1 : 0) != 0);
    }

    public long sizeOf(T var1);

    default public T sizeOfAbstract(T value) {
        return this.fromConst(this.sizeOf(value), 8);
    }

    public static enum Purpose {
        DECODE(PcodeExecutorStatePiece.Reason.EXECUTE_DECODE),
        CONTEXT(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        CONDITION(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        BRANCH(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        LOAD(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        STORE(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        OTHER(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        INSPECT(PcodeExecutorStatePiece.Reason.INSPECT);

        private final PcodeExecutorStatePiece.Reason reason;

        private Purpose(PcodeExecutorStatePiece.Reason reason) {
            this.reason = reason;
        }

        public PcodeExecutorStatePiece.Reason reason() {
            return this.reason;
        }
    }
}

