/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.transform.sc.transformers.CompareToNullExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

class BooleanExpressionTransformer {
    private final StaticCompilationTransformer scTransformer;

    BooleanExpressionTransformer(StaticCompilationTransformer scTransformer) {
        this.scTransformer = scTransformer;
    }

    Expression transformBooleanExpression(BooleanExpression be) {
        if (!(be instanceof NotExpression) && !(be.getExpression() instanceof BinaryExpression)) {
            ClassNode type = this.scTransformer.getTypeChooser().resolveType(be.getExpression(), this.scTransformer.getClassNode());
            return BooleanExpressionTransformer.optimizeBooleanExpression(be, type, this.scTransformer);
        }
        return this.scTransformer.superTransform(be);
    }

    private static Expression optimizeBooleanExpression(BooleanExpression be, ClassNode targetType, ExpressionTransformer transformer) {
        OptimizingBooleanExpression opt = new OptimizingBooleanExpression(transformer.transform(be.getExpression()), targetType);
        opt.setSourcePosition(be);
        opt.copyNodeMetaData(be);
        return opt;
    }

    private static class OptimizingBooleanExpression
    extends BooleanExpression {
        private final ClassNode type;

        OptimizingBooleanExpression(Expression expression, ClassNode type) {
            super(expression);
            this.type = type.redirect();
        }

        @Override
        public Expression transformExpression(ExpressionTransformer transformer) {
            return BooleanExpressionTransformer.optimizeBooleanExpression(this, this.type, transformer);
        }

        @Override
        public void visit(GroovyCodeVisitor visitor) {
            if (visitor instanceof AsmClassGenerator) {
                ClassNode selfType;
                MethodNode method;
                List<MethodNode> asBoolean;
                WriterController controller = ((AsmClassGenerator)visitor).getController();
                MethodVisitor mv = controller.getMethodVisitor();
                OperandStack os = controller.getOperandStack();
                if (ClassHelper.isPrimitiveBoolean(this.type)) {
                    this.getExpression().visit(visitor);
                    os.doGroovyCast(ClassHelper.boolean_TYPE);
                    return;
                }
                if (ClassHelper.isWrapperBoolean(this.type)) {
                    this.getExpression().visit(visitor);
                    Label unbox = new Label();
                    Label exit = new Label();
                    mv.visitInsn(89);
                    mv.visitJumpInsn(199, unbox);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitJumpInsn(167, exit);
                    mv.visitLabel(unbox);
                    if (!os.getTopOperand().equals(this.type)) {
                        BytecodeHelper.doCast(mv, this.type);
                    }
                    mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                    mv.visitLabel(exit);
                    os.replace(ClassHelper.boolean_TYPE);
                    return;
                }
                ClassNode top = this.type;
                if (ClassHelper.isPrimitiveType(top)) {
                    this.getExpression().visit(visitor);
                    top = os.getTopOperand();
                    if (ClassHelper.isPrimitiveType(top)) {
                        BytecodeHelper.convertPrimitiveToBoolean(mv, top);
                        os.replace(ClassHelper.boolean_TYPE);
                        return;
                    }
                }
                if ((asBoolean = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(controller.getSourceUnit().getClassLoader(), top, "asBoolean", ClassNode.EMPTY_ARRAY)).size() == 1 && (method = asBoolean.get(0)) instanceof ExtensionMethodNode && ClassHelper.isObjectType(selfType = ((ExtensionMethodNode)method).getExtensionMethodNode().getParameters()[0].getType()) && (Modifier.isFinal(top.getModifiers()) || OptimizingBooleanExpression.isEffectivelyFinal(top))) {
                    CompareToNullExpression opt = new CompareToNullExpression(this.getExpression(), false);
                    ((ASTNode)opt).visit(visitor);
                    return;
                }
            }
            super.visit(visitor);
        }

        private static boolean isEffectivelyFinal(ClassNode type) {
            if (!Modifier.isPrivate(type.getModifiers())) {
                return false;
            }
            List<ClassNode> outers = type.getOuterClasses();
            ClassNode outer = outers.get(outers.size() - 1);
            return !OptimizingBooleanExpression.isExtended(type, outer.getInnerClasses());
        }

        private static boolean isExtended(ClassNode type, Iterator<? extends ClassNode> inners) {
            while (inners.hasNext()) {
                ClassNode next = inners.next();
                if (next != type && next.isDerivedFrom(type)) {
                    return true;
                }
                if (!OptimizingBooleanExpression.isExtended(type, next.getInnerClasses())) continue;
                return true;
            }
            return false;
        }
    }
}

