/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.debughost.DebugHostModule1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbolEnumerator;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostBaseClassInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostContextInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostModuleInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostBaseClass;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostContext;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostModule1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostSymbolEnumerator;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostType1;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public abstract class DebugHostBaseClassImpl
implements DebugHostBaseClassInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostBaseClass jnaData;

    public DebugHostBaseClassImpl(IDebugHostBaseClass jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostContext getContext() {
        PointerByReference ppContext = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetContext(ppContext));
        WrapIDebugHostContext wrap = new WrapIDebugHostContext(ppContext.getValue());
        try {
            DebugHostContextInternal debugHostContextInternal = DebugHostContextInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostContextInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbolEnumerator enumerateChildren(DbgModelNative.SymbolKind kind, WString name) {
        PointerByReference ppEnum;
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind.ordinal());
        WinNT.HRESULT hr = this.jnaData.EnumerateChildren(ulKind, name, ppEnum = new PointerByReference());
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostSymbolEnumerator wrap = new WrapIDebugHostSymbolEnumerator(ppEnum.getValue());
        try {
            DebugHostSymbolEnumeratorInternal debugHostSymbolEnumeratorInternal = DebugHostSymbolEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public DbgModelNative.SymbolKind getSymbolKind() {
        WinDef.ULONGByReference pulKind = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetSymbolKind(pulKind));
        return DbgModelNative.SymbolKind.values()[pulKind.getValue().intValue()];
    }

    @Override
    public String getName() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetName(bref));
        WTypes.BSTR bstr = bref.getValue();
        String modelName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return modelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getType() {
        PointerByReference ppType = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetType(ppType);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostModule1 getContainingModule() {
        PointerByReference ppType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetContainingModule(ppType));
        WrapIDebugHostModule1 wrap = new WrapIDebugHostModule1(ppType.getValue());
        try {
            DebugHostModuleInternal debugHostModuleInternal = DebugHostModuleInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostModuleInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public long getOffset() {
        WinDef.ULONGLONGByReference ppOffset = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetOffset(ppOffset));
        return ppOffset.getValue().longValue();
    }

    @Override
    public IDebugHostBaseClass getJnaData() {
        return this.jnaData;
    }
}

