/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.debughost.DebugHostModule1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostModuleSignature;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbolEnumerator;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostTypeSignature;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostModuleInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostModuleSignatureInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolsInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeSignatureInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostSymbols;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostModule1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostModuleSignature;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostSymbolEnumerator;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostType1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostTypeSignature;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostSymbolsImpl
implements DebugHostSymbolsInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostSymbols jnaData;
    private DbgModelNative.LOCATION derivedLocation;

    public DebugHostSymbolsImpl(IDebugHostSymbols jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostModuleSignature createModuleSignature(WString pwszModuleName, WString pwszMinVersion, WString pwszMaxVersion) {
        PointerByReference ppModuleSignature = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreateModuleSignature(pwszModuleName, pwszMinVersion, pwszMaxVersion, ppModuleSignature));
        WrapIDebugHostModuleSignature wrap = new WrapIDebugHostModuleSignature(ppModuleSignature.getValue());
        try {
            DebugHostModuleSignatureInternal debugHostModuleSignatureInternal = DebugHostModuleSignatureInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostModuleSignatureInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostTypeSignature createTypeSignature(WString signatureSpecification, DebugHostModule1 module) {
        Pointer pModule = module == null ? null : module.getPointer();
        PointerByReference ppTypeSignature = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreateTypeSignature(signatureSpecification, pModule, ppTypeSignature));
        WrapIDebugHostTypeSignature wrap = new WrapIDebugHostTypeSignature(ppTypeSignature.getValue());
        try {
            DebugHostTypeSignatureInternal debugHostTypeSignatureInternal = DebugHostTypeSignatureInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeSignatureInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostTypeSignature createTypeSignatureForModuleRange(WString signatureSpecification, WString pwszModuleName, WString pwszMinVersion, WString pwszMaxVersion) {
        PointerByReference ppTypeSignature = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreateTypeSignatureForModuleRange(signatureSpecification, pwszModuleName, pwszMinVersion, pwszMaxVersion, ppTypeSignature));
        WrapIDebugHostTypeSignature wrap = new WrapIDebugHostTypeSignature(ppTypeSignature.getValue());
        try {
            DebugHostTypeSignatureInternal debugHostTypeSignatureInternal = DebugHostTypeSignatureInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeSignatureInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbolEnumerator enumerateModules(DebugHostContext context) {
        Pointer pContext = context.getPointer();
        PointerByReference moduleEnum = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateModules(pContext, moduleEnum));
        WrapIDebugHostSymbolEnumerator wrap = new WrapIDebugHostSymbolEnumerator(moduleEnum.getValue());
        try {
            DebugHostSymbolEnumeratorInternal debugHostSymbolEnumeratorInternal = DebugHostSymbolEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostModule1 findModuleByName(DebugHostContext context, String moduleName) {
        Pointer pContext = context.getPointer();
        PointerByReference ppModule = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.FindModuleByName(pContext, new WString(moduleName), ppModule));
        WrapIDebugHostModule1 wrap = new WrapIDebugHostModule1(ppModule.getValue());
        try {
            DebugHostModuleInternal debugHostModuleInternal = DebugHostModuleInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostModuleInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostModule1 findModuleByLocation(DebugHostContext context, DbgModelNative.LOCATION moduleLocation) {
        Pointer pContext = context.getPointer();
        PointerByReference ppModule = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.FindModuleByLocation(pContext, moduleLocation, ppModule));
        WrapIDebugHostModule1 wrap = new WrapIDebugHostModule1(ppModule.getValue());
        try {
            DebugHostModuleInternal debugHostModuleInternal = DebugHostModuleInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostModuleInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getMostDerivedObject(DebugHostContext context, DbgModelNative.LOCATION location, DebugHostType1 objectType) {
        Pointer pContext = context.getPointer();
        Pointer pObjectType = objectType.getPointer();
        DbgModelNative.LOCATION.ByReference pDerivedLocation = new DbgModelNative.LOCATION.ByReference();
        PointerByReference ppDerivedType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetMostDerivedObject(pContext, location, pObjectType, pDerivedLocation, ppDerivedType));
        this.derivedLocation = new DbgModelNative.LOCATION(pDerivedLocation);
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppDerivedType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public DbgModelNative.LOCATION getDerivedLocation() {
        return this.derivedLocation;
    }
}

