/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelPropertyAccessorInternal;
import agent.dbgmodel.jna.dbgmodel.main.IModelPropertyAccessor;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class ModelPropertyAccessorImpl
implements ModelPropertyAccessorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IModelPropertyAccessor jnaData;

    public ModelPropertyAccessorImpl(IModelPropertyAccessor jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getValue(String key, ModelObject contextObject) {
        PointerByReference ppValue;
        Pointer pContextObject = contextObject.getPointer();
        WinNT.HRESULT hr = this.jnaData.GetValue(new WString(key), pContextObject, ppValue = new PointerByReference());
        if (hr.equals((Object)COMUtilsExtra.E_INVALID_PARAM)) {
            System.err.println(key + " invalid param ");
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIModelObject wrap = new WrapIModelObject(ppValue.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public void setValue(String key, ModelObject contextObject, ModelObject value) {
        Pointer pContextObject = contextObject.getPointer();
        Pointer pValue = value.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetValue(new WString(key), pContextObject, pValue));
    }
}

