/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFileDescriptor;
import ghidra.pcode.emu.unix.EmuUnixFileStat;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.program.model.lang.CompilerSpec;
import java.util.Set;

public class DefaultEmuUnixFileHandle<T>
implements EmuUnixFileDescriptor<T> {
    protected final PcodeArithmetic<T> arithmetic;
    protected final EmuUnixFile<T> file;
    protected final Set<EmuUnixFileSystem.OpenFlag> flags;
    protected final EmuUnixUser user;
    protected final int offsetBytes;
    private T offset;

    public DefaultEmuUnixFileHandle(PcodeMachine<T> machine, CompilerSpec cSpec, EmuUnixFile<T> file, Set<EmuUnixFileSystem.OpenFlag> flags, EmuUnixUser user) {
        this.arithmetic = machine.getArithmetic();
        this.file = file;
        this.flags = flags;
        this.user = user;
        this.offsetBytes = cSpec.getDataOrganization().getLongSize();
        this.offset = this.arithmetic.fromConst(0L, this.offsetBytes);
    }

    public EmuUnixFile<T> getFile() {
        return this.file;
    }

    public void checkReadable() {
        if (!EmuUnixFileSystem.OpenFlag.isRead(this.flags)) {
            throw new EmuIOException("File not opened for reading");
        }
    }

    public void checkWritable() {
        if (!EmuUnixFileSystem.OpenFlag.isWrite(this.flags)) {
            throw new EmuIOException("File not opened for writing");
        }
    }

    protected void advanceOffset(T len) {
        int sizeofLen = (int)this.arithmetic.sizeOf(len);
        this.offset = this.arithmetic.binaryOp(19, this.offsetBytes, this.offsetBytes, this.offset, sizeofLen, len);
    }

    @Override
    public T getOffset() {
        return this.offset;
    }

    @Override
    public void seek(T offset) throws EmuIOException {
        this.offset = offset;
    }

    @Override
    public T read(T buf) throws EmuIOException {
        this.checkReadable();
        T len = this.file.read(this.arithmetic, this.offset, buf);
        this.advanceOffset(len);
        return len;
    }

    @Override
    public T write(T buf) throws EmuIOException {
        this.checkWritable();
        if (this.flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_APPEND)) {
            this.offset = this.arithmetic.fromConst(this.file.getStat().st_size, this.offsetBytes);
        }
        T len = this.file.write(this.arithmetic, this.offset, buf);
        this.advanceOffset(len);
        return len;
    }

    @Override
    public EmuUnixFileStat stat() {
        return this.file.getStat();
    }

    @Override
    public void close() {
    }
}

