/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Type;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="TargetTypeContainer", elements={@TargetElementType(type=JdiModelTargetType.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetTypeContainer
extends JdiModelTargetObjectImpl {
    private List<Type> types;
    protected final Map<String, JdiModelTargetType> typesByName = new HashMap<String, JdiModelTargetType>();

    public JdiModelTargetTypeContainer(JdiModelTargetObject parent, String name, List<Type> typeList) {
        super(parent, name);
        this.types = typeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingTypes(Map<String, Type> byName) {
        List vals;
        JdiModelTargetTypeContainer jdiModelTargetTypeContainer = this;
        synchronized (jdiModelTargetTypeContainer) {
            vals = byName.values().stream().map(this::getTargetType).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetType val : vals) {
            fence.include(val.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), vals, Map.of(), "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, Type> map = new HashMap<String, Type>();
        try {
            for (Type type : this.types) {
                map.put(type.name(), type);
            }
            this.typesByName.keySet().retainAll(map.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateUsingTypes(map);
    }

    protected synchronized JdiModelTargetType getTargetType(Type type) {
        return this.typesByName.computeIfAbsent(type.name(), n -> (JdiModelTargetType)this.getInstance(type));
    }

    public synchronized JdiModelTargetType getTargetTypeIfPresent(String name) {
        return this.typesByName.get(name);
    }
}

