/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.parsing.GdbMiParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class GdbFrameInfo {
    private final String level;
    private final String addr;
    private final String func;
    private final List<String> args;

    public static GdbFrameInfo parseInfo(GdbMiParser.GdbMiFieldList info) {
        String level = info.getString("level");
        String addr = info.getString("addr");
        String func = info.getString("func");
        Collection<Object> arginfo = info.get("args");
        ArrayList<String> args = new ArrayList<String>();
        for (Object object : arginfo) {
            if (!(object instanceof GdbMiParser.GdbMiFieldList)) continue;
            args.add(((GdbMiParser.GdbMiFieldList)object).toString());
        }
        return new GdbFrameInfo(level, addr, func, args);
    }

    GdbFrameInfo(String level, String addr, String func, List<String> args) {
        this.level = level;
        this.addr = addr;
        this.func = func;
        this.args = args;
    }

    public int hashCode() {
        return Objects.hash(this.getLevel(), this.getAddr());
    }

    public String toString() {
        return "<GdbFrameInfo level=" + this.getLevel() + ", addr=" + this.getAddr() + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GdbFrameInfo)) {
            return false;
        }
        GdbFrameInfo that = (GdbFrameInfo)obj;
        if (this.getLevel() != that.getLevel()) {
            return false;
        }
        return this.getAddr() == that.getAddr();
    }

    public String getLevel() {
        return this.level;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getFunc() {
        return this.func;
    }

    public List<String> getArgs() {
        return this.args;
    }
}

