/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbEventsListener;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.GdbRegisterSet;
import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbThreadInfo;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.manager.impl.cmd.GdbContinueCommand;
import agent.gdb.manager.impl.cmd.GdbDetachCommand;
import agent.gdb.manager.impl.cmd.GdbEvaluateCommand;
import agent.gdb.manager.impl.cmd.GdbInsertBreakpointCommand;
import agent.gdb.manager.impl.cmd.GdbKillCommand;
import agent.gdb.manager.impl.cmd.GdbListRegisterNamesCommand;
import agent.gdb.manager.impl.cmd.GdbReadMemoryCommand;
import agent.gdb.manager.impl.cmd.GdbReadRegistersCommand;
import agent.gdb.manager.impl.cmd.GdbSetActiveThreadCommand;
import agent.gdb.manager.impl.cmd.GdbSetVarCommand;
import agent.gdb.manager.impl.cmd.GdbStackListFramesCommand;
import agent.gdb.manager.impl.cmd.GdbStepCommand;
import agent.gdb.manager.impl.cmd.GdbWriteMemoryCommand;
import agent.gdb.manager.impl.cmd.GdbWriteRegistersCommand;
import agent.gdb.manager.parsing.GdbCValueParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import agent.gdb.manager.reason.GdbReason;
import generic.ULongSpan;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class GdbThreadImpl
implements GdbThread {
    protected final GdbManagerImpl manager;
    private final int id;
    private final GdbInferiorImpl inferior;
    private final AsyncReference<GdbState, CauseReasonPair> state = new AsyncReference((Object)GdbState.RUNNING);
    private final AsyncLazyValue<GdbRegisterSet> registers = new AsyncLazyValue(this::doListRegisters);

    public GdbThreadImpl(GdbManagerImpl manager, GdbInferiorImpl inferior, int id) {
        this.manager = manager;
        this.id = id;
        this.inferior = inferior;
    }

    @Override
    public GdbInferiorImpl getInferior() {
        return this.inferior;
    }

    public void add() {
        this.inferior.addThread(this);
        this.manager.addThread(this);
        this.state.addChangeListener((oldState, newState, pair) -> this.manager.event(() -> ((GdbEventsListener)this.manager.listenersEvent.fire).threadStateChanged(this, (GdbState)((Object)newState), pair.cause, pair.reason), "threadState"));
    }

    public void remove() {
        this.inferior.removeThread(this.id);
        this.manager.removeThread(this.id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String toString() {
        return "<GdbThread tid=" + this.id + ",inferior=" + this.inferior + ",state=" + this.state.get() + ">";
    }

    @Override
    public GdbState getState() {
        return (GdbState)((Object)this.state.get());
    }

    protected boolean setState(GdbState state, GdbCause cause, GdbReason reason) {
        return this.state.set((Object)state, (Object)new CauseReasonPair(cause, reason));
    }

    protected <T> CompletableFuture<T> execute(AbstractGdbCommand<T> cmd) {
        switch (cmd.getInterpreter()) {
            case CLI: {
                return this.setActive(true).thenCombine(this.manager.execute(cmd), (__, v) -> v);
            }
            case MI2: {
                return this.manager.execute(cmd);
            }
        }
        throw new AssertionError();
    }

    @Override
    public CompletableFuture<Void> setActive(boolean internal) {
        return this.manager.execute(new GdbSetActiveThreadCommand(this.manager, this.id, null, internal));
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.execute(new GdbEvaluateCommand(this.manager, this.id, null, expression));
    }

    @Override
    public CompletableFuture<Void> setVar(String varName, String val) {
        return this.execute(new GdbSetVarCommand(this.manager, this.id, varName, val));
    }

    @Override
    public CompletableFuture<GdbRegisterSet> listRegisters() {
        return this.registers.request();
    }

    private List<String> generateEvaluateSizesParts(Collection<String> names) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buf = new StringBuffer("{");
        for (String n : names) {
            String toAdd = "sizeof($" + n + "),";
            if (buf.length() + toAdd.length() > GdbEvaluateCommand.MAX_EXPR_LEN) {
                assert (buf.length() > 0);
                result.add(buf.substring(0, buf.length() - 1) + "}");
                buf.delete(1, buf.length());
            }
            buf.append(toAdd);
        }
        if (buf.length() > 0) {
            result.add(buf.substring(0, buf.length() - 1) + "}");
        }
        return result;
    }

    private CompletableFuture<List<String>> doEvaluateSizesInParts(Collection<String> names) {
        List<String> parts = this.generateEvaluateSizesParts(names);
        if (parts.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (parts.size() == 1) {
            return this.evaluate(parts.get(0)).thenApply(List::of);
        }
        AsyncFence fence = new AsyncFence();
        String[] result = new String[parts.size()];
        int i = 0;
        while (i < result.length) {
            String p = parts.get(i);
            int j = i++;
            fence.include((CompletableFuture)this.evaluate(p).thenAccept(r -> {
                result[j] = r;
            }));
        }
        return fence.ready().thenApply(__ -> Arrays.asList(result));
    }

    private CompletableFuture<GdbRegisterSet> doListRegisters() {
        TreeMap namesByNumber = new TreeMap();
        return ((CompletableFuture)this.execute(new GdbListRegisterNamesCommand(this.manager, this.id)).thenCompose(names -> {
            for (int i = 0; i < names.size(); ++i) {
                String n = (String)names.get(i);
                if ("".equals(n)) continue;
                namesByNumber.put(i, n);
            }
            return this.doEvaluateSizesInParts(namesByNumber.values());
        })).thenApply(values -> {
            ArrayList<GdbRegister> regs = new ArrayList<GdbRegister>();
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            for (String v : values) {
                try {
                    sizes.addAll(GdbCValueParser.parseArray(v).expectInts());
                }
                catch (GdbParsingUtils.GdbParseError e) {
                    throw new AssertionError((Object)"GDB did not give an integer array!");
                }
            }
            if (sizes.size() != namesByNumber.size()) {
                throw new AssertionError((Object)"GDB did not give all the sizes!");
            }
            Iterator sit = sizes.iterator();
            Iterator eit = namesByNumber.entrySet().iterator();
            while (sit.hasNext()) {
                int size = (Integer)sit.next();
                Map.Entry ent = eit.next();
                regs.add(new GdbRegister((String)ent.getValue(), (Integer)ent.getKey(), size));
            }
            return new GdbRegisterSet(regs);
        });
    }

    @Override
    public CompletableFuture<List<GdbStackFrame>> listStackFrames() {
        return this.execute(new GdbStackListFramesCommand(this.manager, this));
    }

    @Override
    public CompletableFuture<Map<GdbRegister, BigInteger>> readRegisters(Set<GdbRegister> regs) {
        return this.inferior.syncEndianness().thenCompose(__ -> this.execute(new GdbReadRegistersCommand(this.manager, this, null, regs)));
    }

    @Override
    public CompletableFuture<Void> writeRegisters(Map<GdbRegister, BigInteger> regVals) {
        return this.execute(new GdbWriteRegistersCommand(this.manager, this, null, regVals));
    }

    @Override
    public CompletableFuture<ULongSpan.ULongSpanSet> readMemory(long addr, ByteBuffer buf, int len) {
        return this.execute(new GdbReadMemoryCommand(this.manager, this.id, addr, buf, len));
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, ByteBuffer buf, int len) {
        return this.execute(new GdbWriteMemoryCommand(this.manager, this.id, addr, buf, len));
    }

    @Override
    public CompletableFuture<GdbBreakpointInfo> insertBreakpoint(String loc, GdbBreakpointType type) {
        return this.execute(new GdbInsertBreakpointCommand(this.manager, this.id, loc, type));
    }

    @Override
    public CompletableFuture<Void> console(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this.manager, this.id, null, command, GdbConsoleExecCommand.Output.CONSOLE, cwr)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this.manager, this.id, null, command, GdbConsoleExecCommand.Output.CAPTURE, cwr));
    }

    @Override
    public CompletableFuture<Void> cont() {
        return this.execute(new GdbContinueCommand(this.manager, this.id));
    }

    @Override
    public CompletableFuture<Void> step(GdbManager.StepCmd suffix) {
        return this.execute(new GdbStepCommand(this.manager, this.id, suffix));
    }

    @Override
    public CompletableFuture<Void> advance(String loc) {
        return this.console("advance " + loc, GdbConsoleExecCommand.CompletesWithRunning.MUST);
    }

    @Override
    public CompletableFuture<Void> advance(long addr) {
        return this.advance(String.format("*0x%x", addr));
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.execute(new GdbKillCommand(this.manager, this.id));
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.execute(new GdbDetachCommand(this.manager, this.inferior, this.id));
    }

    public void dispose(Throwable reason) {
        this.state.dispose(reason);
    }

    @Override
    public CompletableFuture<GdbThreadInfo> getInfo() {
        return this.manager.getThreadInfo(this.id);
    }

    private static class CauseReasonPair {
        private final GdbCause cause;
        private final GdbReason reason;

        CauseReasonPair(GdbCause cause, GdbReason reason) {
            this.cause = cause;
            this.reason = reason;
        }
    }
}

