/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadAndFrameId;
import ghidra.dbg.util.ConversionUtils;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class GdbWriteRegistersCommand
extends AbstractGdbCommandWithThreadAndFrameId<Void> {
    protected static final BigInteger UINT128_MAX = BigInteger.ONE.shiftLeft(128).subtract(BigInteger.ONE);
    private final GdbThreadImpl thread;
    private final Map<GdbRegister, BigInteger> regVals;

    public GdbWriteRegistersCommand(GdbManagerImpl manager, GdbThreadImpl thread, Integer frameId, Map<GdbRegister, BigInteger> regVals) {
        super(manager, thread.getId(), frameId);
        this.thread = thread;
        this.regVals = regVals;
    }

    protected void encodeInt8Array(StringBuilder b, BigInteger value, int bytes) {
        ByteOrder endianness = this.thread.getInferior().getEndianness();
        byte[] arr = ConversionUtils.bigIntegerToBytes((int)bytes, (BigInteger)value);
        if (endianness != ByteOrder.BIG_ENDIAN) {
            ArrayUtils.reverse((byte[])arr);
        }
        boolean first = true;
        for (int i = 0; i < bytes; ++i) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            int v = arr[i] & 0xFF;
            b.append(v);
        }
    }

    @Override
    protected String encode(String threadPart, String framePart) {
        StringBuilder b = new StringBuilder();
        b.append("-interpreter-exec");
        b.append(threadPart);
        b.append(framePart);
        b.append(" console \"set");
        boolean first = true;
        for (Map.Entry<GdbRegister, BigInteger> ent : this.regVals.entrySet()) {
            if (first) {
                b.append(' ');
                first = false;
            } else {
                b.append(',');
            }
            b.append('$');
            GdbRegister reg = ent.getKey();
            b.append(reg.getName());
            BigInteger value = ent.getValue();
            if (reg.getSize() <= 16) {
                b.append('=');
                b.append(value.toString());
                continue;
            }
            b.append(".v");
            b.append(reg.getSize());
            b.append("_int8={");
            this.encodeInt8Array(b, value, reg.getSize());
            b.append('}');
        }
        b.append("\"");
        return b.toString();
    }

    protected String encodeForMi(String threadPart, String framePart) {
        StringBuilder b = new StringBuilder();
        b.append("-data-write-register-values");
        b.append(threadPart);
        b.append(framePart);
        b.append(" x");
        for (Map.Entry<GdbRegister, BigInteger> ent : this.regVals.entrySet()) {
            b.append(" ");
            b.append(ent.getKey().getNumber());
            b.append(" 0x");
            b.append(ent.getValue().toString(16));
        }
        return b.toString();
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }
}

