/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbEventsListenerAdapter;
import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocation;
import agent.gdb.model.impl.GdbModelTargetBreakpointSpec;
import agent.gdb.model.impl.GdbModelTargetSession;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointContainer", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetBreakpointContainer
extends DefaultTargetObject<GdbModelTargetBreakpointSpec, GdbModelTargetSession>
implements TargetBreakpointSpecContainer,
GdbEventsListenerAdapter {
    public static final String NAME = "Breakpoints";
    protected static final TargetBreakpointSpecContainer.TargetBreakpointKindSet SUPPORTED_KINDS = TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])TargetBreakpointSpec.TargetBreakpointKind.values());
    protected final GdbModelImpl impl;
    protected final Map<Long, GdbModelTargetBreakpointSpec> specsByNumber = new WeakValueHashMap();

    public GdbModelTargetBreakpointContainer(GdbModelTargetSession session) {
        super((AbstractDebuggerObjectModel)session.impl, (TargetObject)session, NAME, "BreakpointContainer");
        this.impl = session.impl;
        this.impl.gdb.addEventsListener(this);
        this.changeAttributes(List.of(), Map.of("_supported_breakpoint_kinds", SUPPORTED_KINDS), "Initialized");
    }

    @Override
    public void breakpointCreated(GdbBreakpointInfo info, GdbCause cause) {
        GdbModelTargetBreakpointSpec spec = this.getTargetBreakpointSpec(info);
        ((CompletableFuture)spec.init().thenRun(() -> this.changeElements(List.of(), List.of(spec), "Created"))).exceptionally(ex -> {
            this.model.reportError((Object)this, "Could not update created breakpoint", ex);
            return null;
        });
    }

    @Override
    public void breakpointModified(GdbBreakpointInfo newInfo, GdbBreakpointInfo oldInfo, GdbCause cause) {
        GdbModelTargetBreakpointSpec spec = this.getTargetBreakpointSpec(oldInfo);
        spec.updateInfo(oldInfo, newInfo, "Modified").exceptionally(ex -> {
            this.model.reportError((Object)this, "Could not updated modified breakpoint", ex);
            return null;
        });
    }

    protected GdbModelTargetBreakpointLocation breakpointHit(long bpId, GdbModelTargetStackFrame frame) {
        GdbModelTargetBreakpointSpec spec = this.getTargetBreakpointSpecIfPresent(bpId);
        if (spec == null) {
            Msg.error((Object)this, (Object)("Stopped for breakpoint unknown to the agent: " + bpId + " (pc=" + frame.getProgramCounter() + ")"));
            return null;
        }
        GdbModelTargetBreakpointLocation loc = spec.findLocation(frame);
        if (loc == null) {
            Msg.warn((Object)this, (Object)("Stopped for a breakpoint whose location is unknown to the agent: " + spec + " (pc=" + frame.getProgramCounter() + ")"));
        }
        this.broadcast().breakpointHit((TargetObject)this, (TargetObject)frame.thread, (TargetStackFrame)frame, (TargetBreakpointSpec)spec, (TargetBreakpointLocation)loc);
        spec.breakpointHit(frame, loc);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void breakpointDeleted(GdbBreakpointInfo info, GdbCause cause) {
        GdbModelTargetBreakpointContainer gdbModelTargetBreakpointContainer = this;
        synchronized (gdbModelTargetBreakpointContainer) {
            this.specsByNumber.remove(info.getNumber());
        }
        this.changeElements(List.of(GdbModelTargetBreakpointSpec.indexBreakpoint(info)), List.of(), "Deleted");
    }

    protected CompletableFuture<Void> doPlaceBreakpoint(Set<TargetBreakpointSpec.TargetBreakpointKind> kinds, Function<GdbBreakpointType, CompletableFuture<?>> placer) {
        AsyncFence fence = new AsyncFence();
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ) && kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(GdbBreakpointType.ACCESS_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ)) {
            fence.include(placer.apply(GdbBreakpointType.READ_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(GdbBreakpointType.HW_WATCHPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE)) {
            fence.include(placer.apply(GdbBreakpointType.HW_BREAKPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE)) {
            fence.include(placer.apply(GdbBreakpointType.BREAKPOINT));
        }
        return this.impl.gateFuture((CompletableFuture)fence.ready().exceptionally(GdbModelImpl::translateEx));
    }

    public CompletableFuture<Void> placeBreakpoint(String expression, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        return this.doPlaceBreakpoint(kinds, t -> this.impl.gdb.insertBreakpoint(expression, (GdbBreakpointType)((Object)t)));
    }

    public CompletableFuture<Void> placeBreakpoint(AddressRange range, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        long offset = range.getMinAddress().getOffset();
        int len = (int)range.getLength();
        return this.doPlaceBreakpoint(kinds, t -> this.impl.gdb.insertBreakpoint(offset, len, (GdbBreakpointType)((Object)t)));
    }

    public synchronized GdbModelTargetBreakpointSpec getTargetBreakpointSpec(GdbBreakpointInfo info) {
        return this.specsByNumber.computeIfAbsent(info.getNumber(), i -> new GdbModelTargetBreakpointSpec(this, info));
    }

    public synchronized GdbModelTargetBreakpointSpec getTargetBreakpointSpecIfPresent(long number) {
        return this.specsByNumber.get(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingBreakpoints(Map<Long, GdbBreakpointInfo> byNumber) {
        List specs;
        GdbModelTargetBreakpointContainer gdbModelTargetBreakpointContainer = this;
        synchronized (gdbModelTargetBreakpointContainer) {
            specs = byNumber.values().stream().map(this::getTargetBreakpointSpec).collect(Collectors.toList());
        }
        return CompletableFuture.allOf((CompletableFuture[])specs.stream().map(s -> s.init()).toArray(CompletableFuture[]::new)).thenRun(() -> this.setElements(specs, "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (!refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            return this.updateUsingBreakpoints(this.impl.gdb.getKnownBreakpoints());
        }
        return this.impl.gdb.listBreakpoints().thenCompose(this::updateUsingBreakpoints);
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return AsyncUtils.NIL;
    }
}

