/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.data.DBWithUserDataContentHandler;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceChangeSet;
import ghidra.trace.database.DBTraceLinkContentHandler;
import ghidra.trace.database.DBTraceUserData;
import ghidra.trace.model.Trace;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;

public class DBTraceContentHandler
extends DBWithUserDataContentHandler<DBTrace> {
    public static final String TRACE_CONTENT_TYPE = "Trace";
    public static final Icon TRACE_ICON = Trace.TRACE_ICON;
    static final Class<DBTrace> TRACE_DOMAIN_OBJECT_CLASS = DBTrace.class;
    static final String TRACE_CONTENT_DEFAULT_TOOL = "Debugger";
    private static final DBTraceLinkContentHandler linkHandler = new DBTraceLinkContentHandler();

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof DBTrace)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((DomainObjectAdapterDB)((DBTrace)obj), TRACE_CONTENT_TYPE, fs, path, name, monitor);
    }

    public DBTrace getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(TRACE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DBTrace trace = null;
        boolean success = false;
        try {
            bf = dbItem.open(version, minChangeVersion);
            dbh = new DBHandle((BufferFile)bf);
            DBOpenMode openMode = DBOpenMode.READ_ONLY;
            trace = new DBTrace(dbh, openMode, monitor, consumer);
            this.getTraceChangeSet(trace, bf);
            success = true;
            DBTrace dBTrace = trace;
            return dBTrace;
        }
        catch (CancelledException | VersionException | IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"GetImmutableObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg, t);
        }
        finally {
            if (!success) {
                if (trace != null) {
                    trace.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DBTrace getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(TRACE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DBTrace trace = null;
        boolean success = false;
        try {
            bf = dbItem.open(version);
            dbh = new DBHandle((BufferFile)bf);
            DBOpenMode openMode = okToUpgrade ? DBOpenMode.UPGRADE : DBOpenMode.UPDATE;
            trace = new DBTrace(dbh, openMode, monitor, consumer);
            this.getTraceChangeSet(trace, bf);
            trace.setTraceUserData(new DBTraceUserData(trace));
            success = true;
            DBTrace dBTrace = trace;
            return dBTrace;
        }
        catch (CancelledException | VersionException | IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getReadOnlyObject failed", (Throwable)t);
            t.printStackTrace();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg, t);
        }
        finally {
            if (!success) {
                if (trace != null) {
                    trace.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DBTrace getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean recover, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(TRACE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DBTrace trace = null;
        boolean success = false;
        try {
            bf = dbItem.openForUpdate(checkoutId);
            dbh = new DBHandle((BufferFile)bf, recover, monitor);
            DBOpenMode openMode = okToUpgrade ? DBOpenMode.UPGRADE : DBOpenMode.UPDATE;
            trace = new DBTrace(dbh, openMode, monitor, consumer);
            if (checkoutId == -1L) {
                this.getTraceChangeSet(trace, bf);
            }
            if (recover) {
                this.recoverChangeSet(trace, dbh);
                trace.setChanged(true);
            }
            trace.setTraceUserData(this.getTraceUserData(trace, (FolderItem)dbItem, userfs, monitor));
            success = true;
            DBTrace dBTrace = trace;
            return dBTrace;
        }
        catch (CancelledException | VersionException | IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getDomainObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg, t);
        }
        finally {
            if (!success) {
                if (trace != null) {
                    trace.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    private DBTraceUserData getTraceUserData(DBTrace trace, FolderItem traceItem, FileSystem userfs, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        if (userfs == null) {
            return null;
        }
        DBHandle userDbh = this.openAssociatedUserFile(traceItem.getFileID(), TRACE_CONTENT_TYPE, userfs, monitor);
        if (userDbh != null) {
            return new DBTraceUserData(userDbh, trace, monitor);
        }
        return new DBTraceUserData(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverChangeSet(DBTrace trace, DBHandle dbh) throws IOException {
        DBTraceChangeSet changeSet = trace.getChangeSet();
        LocalBufferFile cf = dbh.getRecoveryChangeSetFile();
        if (cf != null) {
            DBHandle cfh = null;
            try {
                cfh = new DBHandle((BufferFile)cf);
                changeSet.read(cfh);
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                }
                cf.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBTraceChangeSet getTraceChangeSet(DBTrace trace, ManagedBufferFile bf) throws IOException {
        DBTraceChangeSet changeSet = trace.getChangeSet();
        BufferFile cf = bf.getNextChangeDataFile(true);
        DBHandle cfh = null;
        while (cf != null) {
            try {
                cfh = new DBHandle(cf);
                changeSet.read(cfh);
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                    cfh = null;
                }
                cf.dispose();
            }
            cf = bf.getNextChangeDataFile(false);
        }
        return changeSet;
    }

    public ChangeSet getChangeSet(FolderItem item, int fromVer, int toVer) throws VersionException, IOException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(TRACE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DBTrace trace = null;
        try {
            bf = dbItem.open(toVer, fromVer);
            dbh = new DBHandle((BufferFile)bf);
            DBOpenMode openMode = DBOpenMode.READ_ONLY;
            trace = new DBTrace(dbh, openMode, null, (Object)this);
            DBTraceChangeSet dBTraceChangeSet = this.getTraceChangeSet(trace, bf);
            return dBTraceChangeSet;
        }
        catch (VersionException | IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getChangeSet failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg, t);
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
            if (dbh != null) {
                dbh.close();
            }
            if (bf != null) {
                bf.dispose();
            }
        }
    }

    public Class<DBTrace> getDomainObjectClass() {
        return TRACE_DOMAIN_OBJECT_CLASS;
    }

    public String getContentType() {
        return TRACE_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return TRACE_CONTENT_TYPE;
    }

    public String getDefaultToolName() {
        return TRACE_CONTENT_DEFAULT_TOOL;
    }

    public Icon getIcon() {
        return TRACE_ICON;
    }

    public boolean isPrivateContentType() {
        return false;
    }

    public DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return null;
    }

    public DBTraceLinkContentHandler getLinkHandler() {
        return linkHandler;
    }
}

