/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.property;

import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.map.AbstractDBTracePropertyMap;
import ghidra.trace.database.property.DBTraceAddressPropertyManagerApiView;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.Saveable;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.map.TypeMismatchException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceAddressPropertyManager
implements TraceAddressPropertyManager,
DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBCachedObjectStore<DBTraceAddressPropertyEntry> propertyStore;
    protected final Map<String, AbstractDBTracePropertyMap<?, ?>> propertyMapsByName = new HashMap();
    protected final TraceAddressPropertyManager apiView = new DBTraceAddressPropertyManagerApiView(this);

    public DBTraceAddressPropertyManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.baseLanguage = baseLanguage;
        this.trace = trace;
        this.threadManager = threadManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.propertyStore = factory.getOrCreateCachedStore("AddressProperties", DBTraceAddressPropertyEntry.class, DBTraceAddressPropertyEntry::new, true);
        this.loadPropertyMaps(monitor);
    }

    private void loadPropertyMaps(TaskMonitor monitor) {
        for (DBTraceAddressPropertyEntry ent : this.propertyStore.asMap().values()) {
            if (ent.map == null) {
                try {
                    ent.map = this.doCreateMap(ent.name, DBOpenMode.UPDATE, ent.getValueClass());
                    this.propertyMapsByName.put(ent.name, ent.map);
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Cannot load address property " + ent.name), (Throwable)e);
                }
                continue;
            }
            this.propertyMapsByName.put(ent.name, ent.map);
        }
    }

    protected <T> AbstractDBTracePropertyMap<T, ?> doCreateMap(String name, DBOpenMode openMode, Class<T> valueClass) {
        String tableName = "AddressProperty: " + name;
        try {
            if (valueClass == Integer.class) {
                return new AbstractDBTracePropertyMap.DBTraceIntPropertyMap(tableName, this.dbh, openMode, this.lock, TaskMonitor.DUMMY, this.baseLanguage, this.trace, this.threadManager);
            }
            if (valueClass == Long.class) {
                return new AbstractDBTracePropertyMap.DBTraceLongPropertyMap(tableName, this.dbh, openMode, this.lock, TaskMonitor.DUMMY, this.baseLanguage, this.trace, this.threadManager);
            }
            if (valueClass == String.class) {
                return new AbstractDBTracePropertyMap.DBTraceStringPropertyMap(tableName, this.dbh, openMode, this.lock, TaskMonitor.DUMMY, this.baseLanguage, this.trace, this.threadManager);
            }
            if (valueClass == Void.class) {
                return new AbstractDBTracePropertyMap.DBTraceVoidPropertyMap(tableName, this.dbh, openMode, this.lock, TaskMonitor.DUMMY, this.baseLanguage, this.trace, this.threadManager);
            }
            if (Saveable.class.isAssignableFrom(valueClass)) {
                Class<Saveable> saveableClass = valueClass.asSubclass(Saveable.class);
                return new AbstractDBTracePropertyMap.DBTraceSaveablePropertyMap<Saveable>(tableName, this.dbh, openMode, this.lock, TaskMonitor.DUMMY, this.baseLanguage, this.trace, this.threadManager, saveableClass);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        catch (VersionException e) {
            throw new AssertionError((Object)e);
        }
        throw new IllegalArgumentException("Unsupported value class: " + valueClass);
    }

    public <T> AbstractDBTracePropertyMap<T, ?> createPropertyMap(String name, Class<T> valueClass) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            if (this.propertyMapsByName.containsKey(name)) {
                throw new DuplicateNameException(name);
            }
            DBTraceAddressPropertyEntry ent = (DBTraceAddressPropertyEntry)this.propertyStore.create();
            ent.set(name, valueClass);
            AbstractDBTracePropertyMap<T, ?> map = this.doCreateMap(name, DBOpenMode.CREATE, valueClass);
            ent.map = map;
            this.propertyMapsByName.put(name, map);
            AbstractDBTracePropertyMap<T, ?> abstractDBTracePropertyMap = map;
            return abstractDBTracePropertyMap;
        }
    }

    public <T> AbstractDBTracePropertyMap<T, ?> getPropertyMap(String name, Class<T> valueClass) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AbstractDBTracePropertyMap<?, ?> map = this.propertyMapsByName.get(name);
            if (map == null) {
                AbstractDBTracePropertyMap<T, ?> abstractDBTracePropertyMap = null;
                return abstractDBTracePropertyMap;
            }
            if (valueClass != map.getValueClass()) {
                throw new TypeMismatchException("Property " + name + " has type " + map.getValueClass() + ", not " + valueClass);
            }
            AbstractDBTracePropertyMap<?, ?> abstractDBTracePropertyMap = map;
            return abstractDBTracePropertyMap;
        }
    }

    @Override
    public <T> TracePropertyMap<? extends T> getPropertyMapExtends(String name, Class<T> valueClass) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AbstractDBTracePropertyMap<?, ?> map = this.propertyMapsByName.get(name);
            if (map == null) {
                TracePropertyMap<? extends T> tracePropertyMap = null;
                return tracePropertyMap;
            }
            if (!valueClass.isAssignableFrom(map.getValueClass())) {
                throw new TypeMismatchException("Property " + name + " has type " + map.getValueClass() + ", which does not extend " + valueClass);
            }
            AbstractDBTracePropertyMap<?, ?> abstractDBTracePropertyMap = map;
            return abstractDBTracePropertyMap;
        }
    }

    public <T> AbstractDBTracePropertyMap<T, ?> getOrCreatePropertyMap(String name, Class<T> valueClass) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TracePropertyMap map = this.getPropertyMap(name, (Class)valueClass);
            if (map != null) {
                TracePropertyMap tracePropertyMap = map;
                return tracePropertyMap;
            }
            TracePropertyMap tracePropertyMap = this.createPropertyMap(name, (Class)valueClass);
            return tracePropertyMap;
        }
    }

    @Override
    public <T> TracePropertyMap<? super T> getOrCreatePropertyMapSuper(String name, Class<T> valueClass) {
        AbstractDBTracePropertyMap<?, ?> map;
        LockHold hold;
        block10: {
            hold = LockHold.lock((Lock)this.lock.writeLock());
            map = this.propertyMapsByName.get(name);
            if (map == null) {
                try {
                    TracePropertyMap tracePropertyMap = this.createPropertyMap(name, (Class)valueClass);
                    return tracePropertyMap;
                }
                catch (DuplicateNameException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (map.getValueClass().isAssignableFrom(valueClass)) break block10;
            throw new TypeMismatchException("Property " + name + " has type " + map.getValueClass() + ", which is not a super-type of " + valueClass);
        }
        AbstractDBTracePropertyMap<?, ?> abstractDBTracePropertyMap = map;
        return abstractDBTracePropertyMap;
        finally {
            if (hold != null) {
                hold.close();
            }
        }
    }

    @Override
    public TracePropertyMap<?> getPropertyMap(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TracePropertyMap tracePropertyMap = this.propertyMapsByName.get(name);
            return tracePropertyMap;
        }
    }

    @Override
    public Map<String, TracePropertyMap<?>> getAllProperties() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Map<String, TracePropertyMap<?>> map = Map.copyOf(this.propertyMapsByName);
            return map;
        }
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.propertyStore.invalidateCache();
            this.propertyMapsByName.clear();
            this.loadPropertyMaps(TaskMonitor.DUMMY);
        }
    }

    public TraceAddressPropertyManager getApiPropertyManager() {
        return this.apiView;
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static class DBTraceAddressPropertyEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "AddressProperties";
        static final String NAME_COLUMN_NAME = "Name";
        static final String TYPE_COLUMN_NAME = "Type";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedColumn(value="Type")
        static DBObjectColumn TYPE_COLUMN;
        @DBAnnotatedField(column="Name")
        String name;
        @DBAnnotatedField(column="Type")
        String type;
        AbstractDBTracePropertyMap<?, ?> map;

        public DBTraceAddressPropertyEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(String name, Class<?> valueClass) {
            this.name = name;
            this.type = valueClass.getName();
            this.update(NAME_COLUMN, TYPE_COLUMN);
        }

        Class<?> getValueClass() throws ClassNotFoundException {
            return ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.type);
        }
    }
}

