/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.dbg.util.PathUtils;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DBTraceObjectValPath
implements TraceObjectValPath {
    public static final DBTraceObjectValPath EMPTY = new DBTraceObjectValPath(List.of());
    private final List<InternalTraceObjectValue> entryList;
    private List<String> keyList;

    public static DBTraceObjectValPath of() {
        return EMPTY;
    }

    public static DBTraceObjectValPath of(Collection<InternalTraceObjectValue> entryList) {
        return new DBTraceObjectValPath(List.copyOf(entryList));
    }

    public static DBTraceObjectValPath of(InternalTraceObjectValue ... entries) {
        return DBTraceObjectValPath.of(Arrays.asList(entries));
    }

    private DBTraceObjectValPath(List<InternalTraceObjectValue> entryList) {
        this.entryList = entryList;
    }

    @Override
    public int compareTo(TraceObjectValPath o) {
        return PathUtils.PathComparator.KEYED.compare(this.getKeyList(), o.getKeyList());
    }

    public List<? extends InternalTraceObjectValue> getEntryList() {
        return this.entryList;
    }

    protected List<String> computeKeyList() {
        return this.entryList.stream().map(e -> e.getEntryKey()).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<String> getKeyList() {
        if (this.keyList == null) {
            this.keyList = this.computeKeyList();
        }
        return this.keyList;
    }

    @Override
    public boolean contains(TraceObjectValue entry) {
        return this.entryList.contains(entry);
    }

    @Override
    public DBTraceObjectValPath prepend(TraceObjectValue entry) {
        InternalTraceObjectValue[] arr = new InternalTraceObjectValue[1 + this.entryList.size()];
        arr[0] = (DBTraceObjectValue)entry;
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = this.entryList.get(i - 1);
        }
        return new DBTraceObjectValPath(Collections.unmodifiableList(Arrays.asList(arr)));
    }

    @Override
    public DBTraceObjectValPath append(TraceObjectValue entry) {
        InternalTraceObjectValue[] arr = new InternalTraceObjectValue[1 + this.entryList.size()];
        for (int i = 0; i < arr.length - 1; ++i) {
            arr[i] = this.entryList.get(i);
        }
        arr[arr.length - 1] = (InternalTraceObjectValue)entry;
        return new DBTraceObjectValPath(Collections.unmodifiableList(Arrays.asList(arr)));
    }

    @Override
    public InternalTraceObjectValue getFirstEntry() {
        if (this.entryList.isEmpty()) {
            return null;
        }
        return this.entryList.get(0);
    }

    @Override
    public TraceObject getSource(TraceObject ifEmpty) {
        InternalTraceObjectValue first = this.getFirstEntry();
        return first == null ? ifEmpty : first.getParent();
    }

    @Override
    public InternalTraceObjectValue getLastEntry() {
        if (this.entryList.isEmpty()) {
            return null;
        }
        return this.entryList.get(this.entryList.size() - 1);
    }

    @Override
    public Object getDestinationValue(Object ifEmpty) {
        InternalTraceObjectValue last = this.getLastEntry();
        return last == null ? ifEmpty : last.getValue();
    }

    @Override
    public TraceObject getDestination(TraceObject ifEmpty) {
        InternalTraceObjectValue last = this.getLastEntry();
        return last == null ? ifEmpty : last.getChild();
    }
}

