/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public interface TraceMemoryOperations {
    public Trace getTrace();

    public TraceMemoryRegion addRegion(String var1, Lifespan var2, AddressRange var3, Collection<TraceMemoryFlag> var4) throws TraceOverlappedRegionException, DuplicateNameException;

    default public TraceMemoryRegion addRegion(String path, Lifespan lifespan, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, lifespan, range, Arrays.asList(flags));
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, Lifespan.nowOn(snap), range, flags);
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, Lifespan.nowOn(snap), range, flags);
    }

    public Collection<? extends TraceMemoryRegion> getAllRegions();

    public TraceMemoryRegion getLiveRegionByPath(long var1, String var3);

    public TraceMemoryRegion getRegionContaining(long var1, Address var3);

    public Collection<? extends TraceMemoryRegion> getRegionsIntersecting(Lifespan var1, AddressRange var2);

    public Collection<? extends TraceMemoryRegion> getRegionsAtSnap(long var1);

    public AddressSetView getRegionsAddressSet(long var1);

    public AddressSetView getRegionsAddressSetWith(long var1, Predicate<TraceMemoryRegion> var3);

    public void setState(long var1, AddressRange var3, TraceMemoryState var4);

    public void setState(long var1, Address var3, TraceMemoryState var4);

    public void setState(long var1, Address var3, Address var4, TraceMemoryState var5);

    public void setState(long var1, AddressSetView var3, TraceMemoryState var4);

    public TraceMemoryState getState(long var1, Address var3);

    public Map.Entry<Long, TraceMemoryState> getViewState(long var1, Address var3);

    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getMostRecentStateEntry(long var1, Address var3);

    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long var1, Address var3);

    default public AddressSetView getAddressesWithState(long snap, AddressSetView set, Predicate<TraceMemoryState> predicate) {
        return this.getAddressesWithState(Lifespan.at(snap), set, predicate);
    }

    public AddressSetView getAddressesWithState(Lifespan var1, AddressSetView var2, Predicate<TraceMemoryState> var3);

    public AddressSetView getAddressesWithState(long var1, Predicate<TraceMemoryState> var3);

    public AddressSetView getAddressesWithState(Lifespan var1, Predicate<TraceMemoryState> var2);

    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long var1, AddressRange var3);

    default public boolean isKnown(long snap, AddressRange range) {
        Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> states = this.getStates(snap, range);
        if (states.isEmpty()) {
            return false;
        }
        if (states.size() != 1) {
            return false;
        }
        AddressRange entryRange = states.iterator().next().getKey().getRange();
        return entryRange.contains(range.getMinAddress()) && entryRange.contains(range.getMaxAddress());
    }

    public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(TraceAddressSnapRange var1);

    default public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(long snap, AddressRange range) {
        return this.getMostRecentStates(new ImmutableTraceAddressSnapRange(range.getMinAddress(), range.getMaxAddress(), Long.MIN_VALUE, snap));
    }

    public int putBytes(long var1, Address var3, ByteBuffer var4);

    public int getBytes(long var1, Address var3, ByteBuffer var4);

    public int getViewBytes(long var1, Address var3, ByteBuffer var4);

    public Address findBytes(long var1, AddressRange var3, ByteBuffer var4, ByteBuffer var5, boolean var6, TaskMonitor var7);

    public void removeBytes(long var1, Address var3, int var4);

    public MemBuffer getBufferAt(long var1, Address var3, ByteOrder var4);

    default public MemBuffer getBufferAt(long snap, Address start) {
        return this.getBufferAt(snap, start, this.getTrace().getBaseLanguage().isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public Long getSnapOfMostRecentChangeToBlock(long var1, Address var3);

    public int getBlockSize();

    public void pack();

    public void setState(TracePlatform var1, long var2, Register var4, TraceMemoryState var5);

    default public void setState(long snap, Register register, TraceMemoryState state) {
        this.setState(this.getTrace().getPlatformManager().getHostPlatform(), snap, register, state);
    }

    public TraceMemoryState getState(TracePlatform var1, long var2, Register var4);

    default public TraceMemoryState getState(long snap, Register register) {
        return this.getState(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(TracePlatform var1, long var2, Register var4);

    default public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long snap, Register register) {
        return this.getStates(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public int setValue(TracePlatform var1, long var2, RegisterValue var4);

    default public int setValue(long snap, RegisterValue value) {
        return this.setValue(this.getTrace().getPlatformManager().getHostPlatform(), snap, value);
    }

    public int putBytes(TracePlatform var1, long var2, Register var4, ByteBuffer var5);

    default public int putBytes(long snap, Register register, ByteBuffer buf) {
        return this.putBytes(this.getTrace().getPlatformManager().getHostPlatform(), snap, register, buf);
    }

    public RegisterValue getValue(TracePlatform var1, long var2, Register var4);

    default public RegisterValue getValue(long snap, Register register) {
        return this.getValue(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public RegisterValue getViewValue(TracePlatform var1, long var2, Register var4);

    default public RegisterValue getViewValue(long snap, Register register) {
        return this.getViewValue(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public int getBytes(TracePlatform var1, long var2, Register var4, ByteBuffer var5);

    default public int getBytes(long snap, Register register, ByteBuffer buf) {
        return this.getBytes(this.getTrace().getPlatformManager().getHostPlatform(), snap, register, buf);
    }

    public void removeValue(TracePlatform var1, long var2, Register var4);

    default public void removeValue(long snap, Register register) {
        this.removeValue(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }
}

