/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.annot;

import ghidra.dbg.target.TargetObject;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInfo;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.List;

public final class TraceObjectInterfaceUtils
extends Enum<TraceObjectInterfaceUtils> {
    private static final /* synthetic */ TraceObjectInterfaceUtils[] $VALUES;

    public static TraceObjectInterfaceUtils[] values() {
        return (TraceObjectInterfaceUtils[])$VALUES.clone();
    }

    public static TraceObjectInterfaceUtils valueOf(String name) {
        return Enum.valueOf(TraceObjectInterfaceUtils.class, name);
    }

    public static TraceObjectInfo requireAnnotation(Class<? extends TraceObjectInterface> traceIf) {
        TraceObjectInfo annot = traceIf.getAnnotation(TraceObjectInfo.class);
        if (annot == null) {
            throw new IllegalArgumentException(traceIf + " is missing @" + TraceObjectInfo.class + " annotation");
        }
        return annot;
    }

    public static Class<? extends TargetObject> toTargetIf(Class<? extends TraceObjectInterface> traceIf) {
        return TraceObjectInterfaceUtils.requireAnnotation(traceIf).targetIf();
    }

    public static String getShortName(Class<? extends TraceObjectInterface> traceIf) {
        return TraceObjectInterfaceUtils.requireAnnotation(traceIf).shortName();
    }

    public static Collection<String> getFixedKeys(Class<? extends TraceObjectInterface> traceIf) {
        return List.of(TraceObjectInterfaceUtils.requireAnnotation(traceIf).fixedKeys());
    }

    public static void setLifespan(Class<? extends TraceObjectInterface> traceIf, TraceObject object, Lifespan lifespan) throws DuplicateNameException {
        try (LockHold hold = object.getTrace().lockWrite();){
            for (TraceObjectValue traceObjectValue : object.getParents()) {
                if (!traceObjectValue.isCanonical() || traceObjectValue.isDeleted()) continue;
                traceObjectValue.setLifespan(lifespan, TraceObject.ConflictResolution.DENY);
            }
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateNameException("Duplicate " + TraceObjectInterfaceUtils.getShortName(traceIf) + ": " + e.getMessage());
        }
        object.insert(lifespan, TraceObject.ConflictResolution.TRUNCATE);
        long lower = lifespan.lmin();
        for (String key : TraceObjectInterfaceUtils.getFixedKeys(traceIf)) {
            TraceObjectValue val = object.getValue(lower, key);
            if (val == null) continue;
            val.setLifespan(lifespan, TraceObject.ConflictResolution.TRUNCATE);
        }
    }

    public static <T> T getValue(TraceObject object, long snap, String key, Class<T> cls, T def) {
        TraceObjectValue value = object.getValue(snap, key);
        if (value == null) {
            return def;
        }
        return cls.cast(value.getValue());
    }

    private static /* synthetic */ TraceObjectInterfaceUtils[] $values() {
        return new TraceObjectInterfaceUtils[0];
    }

    static {
        $VALUES = TraceObjectInterfaceUtils.$values();
    }
}

