/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Sequence
implements Comparable<Sequence> {
    public static final String SEP = ";";
    private final List<Step> steps;

    public static Sequence parse(String seqSpec) {
        Sequence result = new Sequence();
        for (String stepSpec : seqSpec.split(SEP)) {
            Step step = Step.parse(stepSpec);
            result.advance(step);
        }
        return result;
    }

    public static Sequence of(Step ... steps) {
        return Sequence.of(Arrays.asList(steps));
    }

    public static Sequence of(List<? extends Step> steps) {
        Sequence result = new Sequence();
        for (Step step : steps) {
            result.advance(step);
        }
        return result;
    }

    public static Sequence catenate(Sequence a, Sequence b) {
        Sequence result = new Sequence();
        result.advance(a);
        result.advance(b);
        return result;
    }

    protected Sequence() {
        this(new ArrayList<Step>());
    }

    protected Sequence(List<Step> steps) {
        this.steps = steps;
    }

    public String toString() {
        return StringUtils.join(this.steps, (String)SEP);
    }

    public void advance(Step step) {
        if (step.isNop()) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.steps.add(step.clone());
            return;
        }
        Step last = this.steps.get(this.steps.size() - 1);
        if (!last.isCompatible(step)) {
            this.steps.add(step.clone());
            return;
        }
        last.addTo(step);
    }

    public void advance(Sequence seq) {
        int size = seq.steps.size();
        List clone = seq.steps.stream().map(Step::clone).collect(Collectors.toList());
        if (size < 1) {
            return;
        }
        this.advance((Step)clone.get(0));
        if (size < 2) {
            return;
        }
        this.advance((Step)clone.get(1));
        this.steps.addAll(clone.subList(2, size));
    }

    public void coalescePatches(Language language) {
        if (this.steps.isEmpty()) {
            return;
        }
        Step last = this.steps.get(this.steps.size() - 1);
        for (long toRemove = last.coalescePatches(language, this.steps); toRemove > 0L; --toRemove) {
            this.steps.remove(this.steps.size() - 1);
        }
    }

    public long rewind(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Cannot rewind a negative number");
        }
        while (!this.steps.isEmpty()) {
            int lastIndex = this.steps.size() - 1;
            count = this.steps.get(lastIndex).rewind(count);
            if (count >= 0L) {
                this.steps.remove(lastIndex);
            }
            if (count > 0L) continue;
            break;
        }
        return Long.max(0L, count);
    }

    public Sequence clone() {
        return new Sequence(this.steps.stream().map(Step::clone).collect(Collectors.toList()));
    }

    public List<Step> getSteps() {
        return this.steps.stream().map(Step::clone).collect(Collectors.toUnmodifiableList());
    }

    public boolean isNop() {
        return this.steps.isEmpty();
    }

    public int hashCode() {
        return this.steps.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence that = (Sequence)obj;
        return Objects.equals(this.steps, that.steps);
    }

    public CompareResult compareSeq(Sequence that) {
        int min = Math.min(this.steps.size(), that.steps.size());
        for (int i = 0; i < min; ++i) {
            Step s1 = this.steps.get(i);
            Step s2 = that.steps.get(i);
            CompareResult result = s1.compareStep(s2);
            switch (result) {
                case UNREL_LT: 
                case UNREL_GT: {
                    return result;
                }
                case REL_LT: {
                    if (i + 1 == this.steps.size()) {
                        return CompareResult.REL_LT;
                    }
                    return CompareResult.UNREL_LT;
                }
                case REL_GT: {
                    if (i + 1 == that.steps.size()) {
                        return CompareResult.REL_GT;
                    }
                    return CompareResult.UNREL_GT;
                }
            }
        }
        if (that.steps.size() > min) {
            return CompareResult.REL_LT;
        }
        if (this.steps.size() > min) {
            return CompareResult.REL_GT;
        }
        return CompareResult.EQUALS;
    }

    @Override
    public int compareTo(Sequence that) {
        return this.compareSeq((Sequence)that).compareTo;
    }

    public Sequence relativize(Sequence prefix) {
        if (prefix.isNop()) {
            return this;
        }
        CompareResult comp = this.compareSeq(prefix);
        Sequence result = new Sequence();
        if (comp == CompareResult.EQUALS) {
            return result;
        }
        if (comp != CompareResult.REL_GT) {
            throw new IllegalArgumentException(String.format("The given prefix (%s) is not actually a prefix of this (%s).", prefix, this));
        }
        int lastStepIndex = prefix.steps.size() - 1;
        Step ancestorLast = prefix.steps.get(lastStepIndex);
        Step continuation = this.steps.get(lastStepIndex);
        result.advance(continuation.subtract(ancestorLast));
        result.steps.addAll(this.steps.subList(prefix.steps.size(), this.steps.size()));
        return result;
    }

    public long totalTickCount() {
        long count = 0L;
        for (Step step : this.steps) {
            count += step.getTickCount();
        }
        return count;
    }

    public long totalPatchCount() {
        long count = 0L;
        for (Step step : this.steps) {
            count += step.getPatchCount();
        }
        return count;
    }

    public TraceThread execute(Trace trace, TraceThread eventThread, PcodeMachine<?> machine, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        TraceThreadManager tm = trace.getThreadManager();
        TraceThread thread = eventThread;
        for (Step step : this.steps) {
            thread = step.execute(tm, thread, machine, stepper, monitor);
        }
        return thread;
    }

    public TraceThread validate(Trace trace, TraceThread eventThread) {
        try {
            return this.execute(trace, eventThread, null, null, null);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getLastThreadKey() {
        if (this.steps.isEmpty()) {
            return -1L;
        }
        return this.steps.get(this.steps.size() - 1).getThreadKey();
    }

    public TraceThread collectThreads(Set<TraceThread> into, Trace trace, TraceThread eventThread) {
        TraceThreadManager tm = trace.getThreadManager();
        TraceThread thread = eventThread;
        for (Step step : this.steps) {
            into.add(thread);
            thread = step.getThread(tm, eventThread);
        }
        return thread;
    }
}

