/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AlignmentDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CondenseFillerBytesAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Condense Filler Bytes";
    private static final String DESCRIPTION = "This analyzer finds filler bytes between functions and collapses them";
    private static final String DEFAULT_FILL_VALUE = "Auto";
    private static final int MIN_BYTES = 1;
    private int minBytes = 1;
    String fillerValue = "Auto";

    public CondenseFillerBytesAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after().after().after().after());
        this.setPrototype();
    }

    String determineFillerValue(Listing listing) {
        FunctionIterator iterator = listing.getFunctions(true);
        HashMap<String, Integer> patterns = new HashMap<String, Integer>();
        while (iterator.hasNext()) {
            String pattern;
            Function function = (Function)iterator.next();
            Address maxAddress = function.getBody().getMaxAddress();
            Data undefinedData = listing.getUndefinedDataAt(maxAddress.next());
            if (undefinedData == null || "??".equals(pattern = ProgramUtilities.getByteCodeString((CodeUnit)undefinedData))) continue;
            if (patterns.containsKey(pattern)) {
                int value = patterns.get(pattern);
                patterns.put(pattern, value + 1);
                continue;
            }
            patterns.put(pattern, 1);
        }
        if (patterns.isEmpty()) {
            return null;
        }
        String filler = this.getMostFrequentFillValue(patterns);
        return filler;
    }

    private String getMostFrequentFillValue(HashMap<String, Integer> fillValuesHash) {
        if (fillValuesHash.isEmpty()) {
            throw new AssertException("Must have filler bytes!");
        }
        Set<Map.Entry<String, Integer>> entries = fillValuesHash.entrySet();
        Map.Entry<String, Integer> max = entries.iterator().next();
        for (Map.Entry<String, Integer> entry : entries) {
            int current = entry.getValue();
            if (current <= max.getValue()) continue;
            max = entry;
        }
        return max.getKey();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Listing listing = program.getListing();
        String filler = "0x" + this.fillerValue;
        if (this.fillerValue.equalsIgnoreCase(DEFAULT_FILL_VALUE)) {
            String fillerBytes = this.determineFillerValue(listing);
            if (fillerBytes == null) {
                return false;
            }
            filler = "0x" + fillerBytes;
        }
        byte[] testBytes = new byte[this.minBytes];
        byte fillerByte = Integer.decode(filler).byteValue();
        Arrays.fill(testBytes, fillerByte);
        byte[] programBytes = new byte[this.minBytes];
        FunctionIterator iterator = listing.getFunctions(true);
        while (iterator.hasNext() && !monitor.isCancelled()) {
            Function functioin = (Function)iterator.next();
            Address fillerAddress = functioin.getBody().getMaxAddress().next();
            Data undefined = listing.getUndefinedDataAt(fillerAddress);
            if (undefined == null) continue;
            String undefinedRepresentation = undefined.getDefaultValueRepresentation();
            if (!this.getBytes(program.getMemory(), fillerAddress, programBytes) || !Arrays.equals(programBytes, testBytes)) continue;
            int fillerLength = this.countUndefineds(program, fillerAddress, undefinedRepresentation);
            this.replaceFillerBytes(listing, fillerAddress, fillerLength);
        }
        return true;
    }

    private boolean getBytes(Memory memory, Address fillerAddress, byte[] programBytes) {
        try {
            memory.getBytes(fillerAddress, programBytes);
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    private int countUndefineds(Program p, Address address, String undefinedString) {
        String currentString;
        Address next;
        Data undefined;
        int undefinedCount = 1;
        Listing listing = p.getListing();
        AddressSet allAddressAfter = new AddressSet(p, address, p.getMaxAddress());
        AddressIterator iterator = allAddressAfter.getAddresses(address.next(), true);
        while (iterator.hasNext() && (undefined = listing.getUndefinedDataAt(next = iterator.next())) != null && undefinedString.equalsIgnoreCase(currentString = undefined.getDefaultValueRepresentation())) {
            ++undefinedCount;
        }
        return undefinedCount;
    }

    private void replaceFillerBytes(Listing listing, Address fillerAddress, int fillerLength) {
        try {
            listing.createData(fillerAddress, (DataType)new AlignmentDataType(), fillerLength);
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)("Unable to condense filler bytes (bad filler value?) at " + fillerAddress), (Throwable)e);
            return;
        }
    }

    @Override
    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption("Minimum number of sequential bytes", (Object)this.minBytes, null, "Enter the minimum number of sequential bytes to collapse");
        options.registerOption("Filler Value", (Object)this.fillerValue, null, "Enter filler byte to search for and collapse (Examples:  0, 00, 90, cc).  \"Auto\" will make the program determine the value (by greatest count).");
        this.optionsChanged(options, program);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.fillerValue = options.getString("Filler Value", this.fillerValue);
        this.minBytes = options.getInt("Minimum number of sequential bytes", this.minBytes);
    }
}

