/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.coff.AoutHeader;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffLineNumber;
import ghidra.app.util.bin.format.coff.CoffMachineType;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.framework.options.Options;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class CoffBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();

    @Override
    public boolean canApply(Program program) {
        try {
            Options options = program.getOptions("Program Information");
            String format = options.getString("Executable Format", null);
            if (!"Raw Binary".equals(format)) {
                return false;
            }
            MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
            return CoffFileHeader.isValid(provider);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
        CoffFileHeader header = new CoffFileHeader(provider);
        if (!CoffMachineType.isMachineTypeDefined(header.getMagic())) {
            return false;
        }
        header.parse(provider, monitor);
        this.applyDataTypes(header);
        this.removeEmptyFragments();
        return true;
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        return aam.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public String getName() {
        return "COFF Header Annotation";
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    private void removeEmptyFragments() throws NotEmptyException {
        String[] treeNames;
        this.monitor.setMessage("Removing empty fragments...");
        block0: for (String treeName : treeNames = this.currentProgram.getListing().getTreeNames()) {
            Group[] children;
            if (this.monitor.isCancelled()) break;
            ProgramModule rootModule = this.currentProgram.getListing().getRootModule(treeName);
            for (Group child : children = rootModule.getChildren()) {
                ProgramFragment fragment;
                if (this.monitor.isCancelled()) continue block0;
                if (!(child instanceof ProgramFragment) || !(fragment = (ProgramFragment)child).isEmpty()) continue;
                rootModule.removeChild(fragment.getName());
            }
        }
    }

    private void applyDataTypes(CoffFileHeader header) throws Exception {
        this.processFileHeader(header);
        this.processOptionalHeader(header);
        this.processSectionHeaders(header);
        this.processSymbols(header);
        this.processStrings(header);
    }

    private void processOptionalHeader(CoffFileHeader header) throws Exception {
        if (header.getOptionalHeaderSize() == 0) {
            return;
        }
        AoutHeader optionalHeader = header.getOptionalHeader();
        Address address = this.toAddr(header.sizeof());
        DataType dt = optionalHeader.toDataType();
        this.createData(address, dt);
        this.createFragment(dt.getName(), address, dt.getLength());
    }

    private void processStrings(CoffFileHeader header) throws Exception {
        Address start;
        this.monitor.setMessage("Processing strings...");
        Address address = start = this.toAddr(header.getSymbolTablePointer() + header.getSymbolTableEntries() * 18);
        this.createData(address, (DataType)new DWordDataType());
        this.createLabel(address, "Number_of_strings", true);
        address = address.add(4L);
        while (address.compareTo((Object)this.currentProgram.getMaxAddress()) < 0 && !this.monitor.isCancelled()) {
            Data data = this.createData(address, (DataType)new StringDataType());
            address = address.add((long)data.getLength());
        }
        this.createFragment("Strings", start, address.subtract(start));
    }

    private void processSymbols(CoffFileHeader header) throws Exception {
        this.monitor.setMessage("Processing symbols...");
        Address start = this.toAddr(header.getSymbolTablePointer());
        long length = header.getSymbolTableEntries() * 18;
        Address address = start;
        List<CoffSymbol> symbols = header.getSymbols();
        for (int i = 0; i < symbols.size() && !this.monitor.isCancelled(); ++i) {
            CoffSymbol symbol = symbols.get(i);
            DataType dt = symbol.toDataType();
            this.createData(address, dt);
            this.setPlateComment(address, symbol.getName());
            address = address.add((long)dt.getLength());
            List<CoffSymbolAux> auxiliarySymbols = symbol.getAuxiliarySymbols();
            for (CoffSymbolAux auxSymbol : auxiliarySymbols) {
                DataType auxDT = auxSymbol.toDataType();
                this.createData(address, auxDT);
                this.setPlateComment(address, "Auxiliary for " + symbol.getName());
                address = address.add((long)auxDT.getLength());
            }
        }
        this.createFragment("Symbols", start, length);
    }

    private void processSectionHeaders(CoffFileHeader header) throws Exception {
        this.monitor.setMessage("Processing sections...");
        List<CoffSectionHeader> sections = header.getSections();
        Address address = this.toAddr(header.sizeof() + header.getOptionalHeaderSize());
        for (CoffSectionHeader section : sections) {
            if (this.monitor.isCancelled()) break;
            DataType dt = section.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            this.setPlateComment(address, section.getName());
            address = address.add((long)dt.getLength());
            this.processSectionRelocations(section);
            this.processSectionLineNumbers(section);
            if (section.getSize(this.currentProgram.getLanguage()) == 0 || section.isUninitializedData()) continue;
            Address byteAddress = this.toAddr(section.getPointerToRawData());
            long length = section.getSize(this.currentProgram.getLanguage());
            this.createFragment(section.getName() + "-Data", byteAddress, length);
        }
    }

    private void processSectionLineNumbers(CoffSectionHeader section) throws Exception {
        this.monitor.setMessage("Processing section line numbers...");
        if (section.getLineNumberCount() == 0) {
            return;
        }
        Address start = this.toAddr(section.getPointerToLineNumbers());
        long length = section.getLineNumberCount() * 6;
        Address address = start;
        List<CoffLineNumber> lineNumbers = section.getLineNumbers();
        for (CoffLineNumber lineNumber : lineNumbers) {
            if (this.monitor.isCancelled()) break;
            DataType dt = lineNumber.toDataType();
            this.createData(address, dt);
            address = address.add((long)dt.getLength());
        }
        this.createFragment(section.getName() + "-LineNumbers", start, length);
    }

    private void processSectionRelocations(CoffSectionHeader section) throws Exception {
        Address start;
        this.monitor.setMessage("Processing section relocations...");
        if (section.getRelocationCount() == 0) {
            return;
        }
        int relocationSize = 0;
        Address address = start = this.toAddr(section.getPointerToRelocations());
        List<CoffRelocation> relocations = section.getRelocations();
        for (CoffRelocation relocation : relocations) {
            if (this.monitor.isCancelled()) break;
            relocationSize += relocation.sizeof();
            DataType dt = relocation.toDataType();
            this.createData(address, dt);
            address = address.add((long)dt.getLength());
        }
        this.createFragment(section.getName() + "-Relocations", start, relocationSize);
    }

    private void processFileHeader(CoffFileHeader header) throws Exception {
        DataType dt = header.toDataType();
        Address startAddr = this.toAddr(0);
        this.createData(startAddr, dt);
        this.createFragment(dt.getName(), startAddr, dt.getLength());
    }
}

