/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.context;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.RestrictedAddressSetContext;

public abstract class NavigatableContextAction
extends DockingAction {
    private final boolean supportsRestrictedAddressSetContext;

    public NavigatableContextAction(String name, String owner) {
        this(name, owner, true);
    }

    public NavigatableContextAction(String name, String owner, boolean supportsRestrictedAddressSetContext) {
        super(name, owner);
        this.setSupportsDefaultToolContext(true);
        this.supportsRestrictedAddressSetContext = supportsRestrictedAddressSetContext;
    }

    public NavigatableContextAction(String name, String owner, KeyBindingType type) {
        super(name, owner, type);
        this.setSupportsDefaultToolContext(true);
        this.supportsRestrictedAddressSetContext = true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            return this.isEnabledForContext((NavigatableActionContext)context);
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            this.actionPerformed((NavigatableActionContext)context);
        }
    }

    public final boolean isValidContext(ActionContext context) {
        if (!this.supportsRestrictedAddressSetContext && context instanceof RestrictedAddressSetContext) {
            return false;
        }
        return context instanceof NavigatableActionContext;
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof NavigatableActionContext)) {
            return false;
        }
        return this.isAddToPopup((NavigatableActionContext)context);
    }

    protected boolean isEnabledForContext(NavigatableActionContext context) {
        return context.getLocation() != null;
    }

    protected boolean isAddToPopup(NavigatableActionContext context) {
        return this.isEnabledForContext(context);
    }

    protected abstract void actionPerformed(NavigatableActionContext var1);
}

