/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import generic.theme.GThemeDefaults;
import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.FunctionTagManagerDB;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class FunctionTagMerger
implements MergeResolver,
ListingMergeConstants {
    private static String[] FUNCTION_TAG_PHASE = new String[]{"Function Tags"};
    protected static final int RESULT = 0;
    protected static final int LATEST = 1;
    protected static final int MY = 2;
    protected static final int ORIGINAL = 3;
    private ProgramMultiUserMergeManager mergeManager;
    private Program resultProgram;
    private Program originalProgram;
    private Program latestProgram;
    private Program myProgram;
    ProgramChangeSet latestChanges;
    ProgramChangeSet myChanges;
    private VerticalChoicesPanel conflictPanel;
    private int conflictOption;
    private int conflictChoice = 0;
    private Map<Long, String> tagConflicts = new HashMap<Long, String>();
    private long currentlyMergingTagID;

    public FunctionTagMerger(ProgramMultiUserMergeManager mergeManager, Program resultPgm, Program originalPgm, Program latestPgm, Program myPgm, ProgramChangeSet latestChanges, ProgramChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.resultProgram = resultPgm;
        this.originalProgram = originalPgm;
        this.latestProgram = latestPgm;
        this.myProgram = myPgm;
        this.myChanges = myChanges;
        this.latestChanges = latestChanges;
    }

    @Override
    public String getName() {
        return "Function Tag Merger";
    }

    @Override
    public String getDescription() {
        return "Merge Function Tags";
    }

    @Override
    public void apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.conflictChoice = this.conflictOption;
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -1;
        if (this.conflictPanel != null) {
            this.conflictPanel.clear();
        }
    }

    @Override
    public void merge(TaskMonitor monitor) throws Exception {
        this.autoMerge();
        this.handleConflicts(monitor);
        if (this.conflictPanel != null) {
            this.mergeManager.removeComponent(this.conflictPanel);
            this.conflictPanel = null;
        }
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{FUNCTION_TAG_PHASE};
    }

    private void handleConflicts(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Resolving Function Tag conflicts");
        boolean askUser = this.conflictOption == 0;
        int totalConflicts = this.tagConflicts.size();
        monitor.initialize((long)totalConflicts);
        for (long id : this.tagConflicts.keySet()) {
            if (this.conflictChoice == 0 && askUser && this.mergeManager != null) {
                monitor.checkCancelled();
                this.currentlyMergingTagID = id;
                this.showMergePanel(id, monitor);
            } else {
                int optionToUse = this.conflictChoice == 0 ? this.conflictOption : this.conflictChoice;
                this.currentlyMergingTagID = id;
                this.merge(optionToUse, monitor);
            }
            monitor.incrementProgress(1L);
            int pctComplete = (int)(monitor.getProgress() / (long)totalConflicts * 100L);
            this.mergeManager.updateProgress(pctComplete);
        }
    }

    private void merge(int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        Program fromPgm = null;
        switch (chosenConflictOption) {
            case 2: {
                fromPgm = this.latestProgram;
                break;
            }
            case 4: {
                fromPgm = this.myProgram;
                break;
            }
            case 1: {
                fromPgm = this.originalProgram;
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.merge(fromPgm, monitor);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"error merging conflict", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(Program sourceProgram, TaskMonitor monitor) throws CancelledException, IOException {
        FunctionTag tag = this.getTag(sourceProgram, this.currentlyMergingTagID);
        FunctionTag resultTag = this.getTag(this.resultProgram, this.currentlyMergingTagID);
        FunctionManagerDB functionManagerDBResult = (FunctionManagerDB)this.resultProgram.getFunctionManager();
        int transactionID = this.resultProgram.startTransaction(this.getDescription());
        try {
            if (tag == null) {
                if (resultTag != null) {
                    resultTag.delete();
                }
            } else if (resultTag == null) {
                functionManagerDBResult.getFunctionTagManager().createFunctionTag(tag.getName(), tag.getComment());
            } else {
                resultTag.setName(tag.getName());
                resultTag.setComment(tag.getComment());
            }
        }
        finally {
            this.resultProgram.endTransaction(transactionID, true);
        }
        this.mergeManager.setCompleted(FUNCTION_TAG_PHASE);
    }

    private FunctionTag getTag(Program program, long id) {
        FunctionManagerDB functionManagerDBResult = (FunctionManagerDB)program.getFunctionManager();
        FunctionTag tag = functionManagerDBResult.getFunctionTagManager().getFunctionTag(id);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoMerge() throws IOException {
        FunctionManagerDB myFunctionManagerDB = (FunctionManagerDB)this.myProgram.getFunctionManager();
        FunctionTagManagerDB tagManagerMY = (FunctionTagManagerDB)myFunctionManagerDB.getFunctionTagManager();
        FunctionManagerDB latestFunctionManagerDB = (FunctionManagerDB)this.latestProgram.getFunctionManager();
        FunctionTagManagerDB tagManagerLATEST = (FunctionTagManagerDB)latestFunctionManagerDB.getFunctionTagManager();
        FunctionManagerDB resultFunctionManagerDB = (FunctionManagerDB)this.resultProgram.getFunctionManager();
        FunctionTagManagerDB tagManagerRESULT = (FunctionTagManagerDB)resultFunctionManagerDB.getFunctionTagManager();
        FunctionManagerDB originalFunctionManagerDB = (FunctionManagerDB)this.originalProgram.getFunctionManager();
        FunctionTagManagerDB tagManagerORIGINAL = (FunctionTagManagerDB)originalFunctionManagerDB.getFunctionTagManager();
        long[] myAdditionIDs = this.myChanges.getTagCreations();
        long[] myChangeIDs = this.myChanges.getTagChanges();
        long[] latestAdditionIDs = this.latestChanges.getTagCreations();
        long[] latestChangeIDs = this.latestChanges.getTagChanges();
        List<Long> myEditedIDs = this.getEdits(myChangeIDs, (FunctionTagManager)tagManagerMY, (FunctionTagManager)tagManagerORIGINAL);
        List<Long> latestEditedIDs = this.getEdits(latestChangeIDs, (FunctionTagManager)tagManagerLATEST, (FunctionTagManager)tagManagerORIGINAL);
        List<Long> myDeletedIDs = this.getDeletes(myChangeIDs, (FunctionTagManager)tagManagerMY, (FunctionTagManager)tagManagerORIGINAL);
        List<Long> latestDeletedIDs = this.getDeletes(latestChangeIDs, (FunctionTagManager)tagManagerLATEST, (FunctionTagManager)tagManagerORIGINAL);
        int transactionID = this.resultProgram.startTransaction(this.getDescription());
        try {
            this.mergeAdditions(tagManagerMY, tagManagerLATEST, tagManagerRESULT, myAdditionIDs, latestAdditionIDs);
            this.mergeDeletions(tagManagerRESULT, myEditedIDs, latestEditedIDs, myDeletedIDs, latestDeletedIDs);
            this.mergeEdits(tagManagerMY, tagManagerLATEST, tagManagerRESULT, myEditedIDs, latestEditedIDs, latestDeletedIDs);
        }
        finally {
            this.resultProgram.endTransaction(transactionID, true);
        }
    }

    private void mergeEdits(FunctionTagManagerDB tagManagerMY, FunctionTagManagerDB tagManagerLATEST, FunctionTagManagerDB tagManagerRESULT, List<Long> myEditedIDs, List<Long> latestEditedIDs, List<Long> latestDeletedIDs) {
        String CONFLICT_REASON = "Tag name and/or comment edited in both programs";
        for (long id : myEditedIDs) {
            FunctionTag functionTag;
            FunctionTag tagMy = tagManagerMY.getFunctionTag(id);
            if (latestEditedIDs.contains(id)) {
                this.tagConflicts.put(id, CONFLICT_REASON);
                continue;
            }
            if (latestDeletedIDs.contains(id) || (functionTag = tagManagerRESULT.getFunctionTag(id)) == null) continue;
            functionTag.setName(tagMy.getName());
            functionTag.setComment(tagMy.getComment());
        }
        for (long id : latestEditedIDs) {
            if (!myEditedIDs.contains(id)) continue;
            this.tagConflicts.put(id, CONFLICT_REASON);
        }
    }

    private void mergeDeletions(FunctionTagManagerDB tagManagerRESULT, List<Long> myEditedIDs, List<Long> latestEditedIDs, List<Long> myDeletedIDs, List<Long> latestDeletedIDs) {
        FunctionTag tag;
        String CONFLICT_REASON = "Tag was deleted in one program but edited in another";
        for (long id : myDeletedIDs) {
            if (latestEditedIDs.contains(id)) {
                this.tagConflicts.put(id, CONFLICT_REASON);
                continue;
            }
            tag = tagManagerRESULT.getFunctionTag(id);
            if (tag == null) continue;
            tag.delete();
        }
        for (long id : latestDeletedIDs) {
            if (myEditedIDs.contains(id)) {
                this.tagConflicts.put(id, CONFLICT_REASON);
                continue;
            }
            tag = tagManagerRESULT.getFunctionTag(id);
            if (tag == null) continue;
            tag.delete();
        }
    }

    private void mergeAdditions(FunctionTagManagerDB tagManagerMY, FunctionTagManagerDB tagManagerLATEST, FunctionTagManagerDB tagManagerRESULT, long[] myAdditionIDs, long[] latestAdditionIDs) {
        String CONFLICT_REASON = "Identical tag names added, but comments differ";
        for (long id : myAdditionIDs) {
            FunctionTag myTag = tagManagerMY.getFunctionTag(id);
            FunctionTag latestTag = tagManagerLATEST.getFunctionTag(id);
            if (myTag == null) {
                return;
            }
            if (latestTag != null && myTag.getName().equals(latestTag.getName()) && !myTag.getComment().equals(latestTag.getComment())) {
                this.tagConflicts.put(id, CONFLICT_REASON);
                continue;
            }
            tagManagerRESULT.createFunctionTag(myTag.getName(), myTag.getComment());
        }
    }

    private List<Long> getEdits(long[] ids, FunctionTagManager tagManager, FunctionTagManager originalTagManager) {
        ArrayList<Long> retList = new ArrayList<Long>();
        for (long id : ids) {
            FunctionTag tag = tagManager.getFunctionTag(id);
            FunctionTag originalTag = originalTagManager.getFunctionTag(id);
            if (tag == null || originalTag == null || tag.getName().equals(originalTag.getName()) && tag.getComment().equals(originalTag.getComment())) continue;
            retList.add(id);
        }
        return retList;
    }

    private List<Long> getDeletes(long[] ids, FunctionTagManager tagManager, FunctionTagManager originalTagManager) {
        ArrayList<Long> retList = new ArrayList<Long>();
        for (long id : ids) {
            FunctionTag tag = tagManager.getFunctionTag(id);
            FunctionTag originalTag = originalTagManager.getFunctionTag(id);
            if (tag != null || originalTag == null) continue;
            retList.add(id);
        }
        return retList;
    }

    private void showMergePanel(long id, TaskMonitor monitor) {
        try {
            ChangeListener changeListener = e -> {
                this.conflictOption = this.conflictPanel.getSelectedOptions();
                if (this.conflictOption == 0 || this.conflictOption == -1) {
                    if (this.mergeManager != null) {
                        this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (this.mergeManager != null) {
                    this.mergeManager.clearStatusText();
                }
                try {
                    this.merge(this.conflictOption, monitor);
                    if (this.mergeManager != null) {
                        this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            };
            SwingUtilities.invokeAndWait(() -> this.setupConflictPanel(id, changeListener, monitor));
        }
        catch (InterruptedException | InvocationTargetException e2) {
            Msg.error((Object)this, (Object)("Unexpected error showing merge panel for tag " + id), (Throwable)e2);
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showComponent(this.conflictPanel, "FunctionTagMerge", new HelpLocation("Repository", "FunctionTags"));
        }
    }

    private FunctionTag getTag(Long id, Program program) throws IOException {
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        return functionManagerDB.getFunctionTagManager().getFunctionTag(id.longValue());
    }

    public void setConflictResolution(int option) {
        this.conflictOption = option;
        this.conflictChoice = option;
    }

    private void setupConflictPanel(long id, ChangeListener listener, TaskMonitor monitor) {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
        } else {
            this.conflictPanel.clear();
        }
        this.conflictPanel.setHeader(this.getConflictInfo(monitor));
        this.conflictPanel.setTitle("Function Tags");
        this.conflictPanel.setUseForAll(false);
        this.conflictPanel.setConflictType("Function Tags");
        try {
            FunctionTag originalTag = this.getTag(id, this.originalProgram);
            String originalName = originalTag == null ? "<tag deleted>" : originalTag.getName();
            String originalComment = originalTag == null ? "" : originalTag.getComment();
            FunctionTag latestTag = this.getTag(id, this.latestProgram);
            String latestName = latestTag == null ? "<tag deleted>" : latestTag.getName();
            String latestComment = latestTag == null ? "" : latestTag.getComment();
            FunctionTag myTag = this.getTag(id, this.myProgram);
            String myName = myTag == null ? "<tag deleted>" : myTag.getName();
            String myComment = myTag == null ? "" : myTag.getComment();
            this.conflictPanel.setRowHeader(new String[]{"Option", "Function Tags"});
            this.conflictPanel.setRowHeader(this.getFunctionTagInfo(-1, null, null));
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(1, latestName, latestComment), "LatestVersionRB", 2, listener);
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(2, myName, myComment), "CheckedOutVersionRB", 4, listener);
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(3, originalName, originalComment), "OriginalVersionRB", 1, listener);
            this.currentlyMergingTagID = id;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error creating conflict dialog for " + id), (Throwable)e);
        }
    }

    private String getConflictInfo(TaskMonitor monitor) {
        StringBuilder buf = new StringBuilder();
        buf.append("<center><b>Resolving conflict " + (monitor.getProgress() + 1L) + " of " + this.tagConflicts.size() + "</b></center>");
        buf.append(HTMLUtilities.HTML_NEW_LINE);
        buf.append("Tag Id:");
        buf.append(HTMLUtilities.spaces((int)21));
        buf.append(HTMLUtilities.colorString((Color)GThemeDefaults.Colors.Messages.NORMAL, (String)String.valueOf(this.currentlyMergingTagID)));
        buf.append(HTMLUtilities.HTML_NEW_LINE);
        buf.append("Reason for Conflict:");
        buf.append(HTMLUtilities.spaces((int)1));
        buf.append(HTMLUtilities.colorString((Color)GThemeDefaults.Colors.Messages.NORMAL, (String)this.tagConflicts.get(this.currentlyMergingTagID)));
        buf.append(HTMLUtilities.HTML_NEW_LINE);
        buf.append(HTMLUtilities.HTML_NEW_LINE);
        return buf.toString();
    }

    private String[] getFunctionTagInfo(int version, String name, String comment) {
        String[] info = new String[]{"Keep", "", name, comment};
        if (version == 1) {
            info[1] = "Latest";
        } else if (version == 2) {
            info[1] = "Checked Out";
        } else if (version == 3) {
            info[1] = "Original";
        } else {
            return new String[]{"Option", "Type", "Name", "Comment"};
        }
        return info;
    }
}

