/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.framework.cmd.MergeableBackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;

public class AnalysisBackgroundCommand
extends MergeableBackgroundCommand {
    private AutoAnalysisManager mgr;
    private boolean markAsAnalyzed;

    public AnalysisBackgroundCommand(AutoAnalysisManager mgr, boolean markAsAnalyzed) {
        super("Auto Analysis", true, true, false);
        this.mgr = mgr;
        this.markAsAnalyzed = markAsAnalyzed;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        if (this.markAsAnalyzed) {
            GhidraProgramUtilities.markProgramAnalyzed((Program)obj);
        }
        this.mgr.startAnalysis(monitor);
        return true;
    }

    public MergeableBackgroundCommand mergeCommands(MergeableBackgroundCommand command) {
        SystemUtilities.assertTrue((boolean)(command instanceof AnalysisBackgroundCommand), (String)"This code assumes that the two commands are both AnalysisBackgroundCommands and this is not the case.");
        AnalysisBackgroundCommand abc = (AnalysisBackgroundCommand)command;
        SystemUtilities.assertTrue((this.mgr == abc.mgr ? 1 : 0) != 0, (String)"This code assumes that the managers of the two commands are the same instance and this is not the case.");
        this.markAsAnalyzed |= abc.markAsAnalyzed;
        return this;
    }
}

