/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.InputStreamByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.dwarf.DwarfSectionNames;
import ghidra.app.util.bin.format.dwarf.line.FileEntry;
import ghidra.app.util.bin.format.dwarf.line.StateMachine;
import ghidra.app.util.bin.format.dwarf.line.StatementProgramInstructions;
import ghidra.app.util.bin.format.dwarf.line.StatementProgramPrologue;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DwarfLineNumberAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "DWARF Line Number";
    private static final String DESCRIPTION = "Extracts DWARF debug line number information.";

    public DwarfLineNumberAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after().after().after());
        this.setPrototype();
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        DwarfSectionNames sectionNames = new DwarfSectionNames(program);
        try {
            ByteProvider provider = this.getByteProvider(program, sectionNames);
            if (provider == null) {
                return true;
            }
            BinaryReader reader = new BinaryReader(provider, !program.getLanguage().isBigEndian());
            block2: while (!monitor.isCancelled() && reader.hasNext()) {
                long startIndex = reader.getPointerIndex();
                StatementProgramPrologue prologue = new StatementProgramPrologue(reader);
                StateMachine machine = new StateMachine();
                machine.reset(prologue.isDefaultIsStatement());
                StatementProgramInstructions instructions = new StatementProgramInstructions(reader, machine, prologue);
                while (!monitor.isCancelled()) {
                    instructions.execute();
                    FileEntry entry = prologue.getFileNameByIndex(machine.file);
                    String directory = prologue.getDirectoryByIndex(entry.getDirectoryIndex());
                    Address address = space.getAddress(machine.address);
                    CodeUnit cu = program.getListing().getCodeUnitContaining(address);
                    if (cu != null) {
                        cu.setProperty("Source Path", directory + File.separator + entry.getFileName());
                        cu.setProperty("Source File", entry.getFileName());
                        cu.setProperty("Source Line", machine.line);
                    }
                    if (reader.getPointerIndex() - startIndex < (long)(prologue.getTotalLength() + 4)) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteProvider getByteProvider(Program program, DwarfSectionNames sectionNames) throws IOException {
        File exePath = new File(program.getExecutablePath());
        if ("Mac OS X Mach-O".equals(program.getExecutableFormat())) {
            File parent = exePath.getParentFile();
            File dSymFile = new File(parent, exePath.getName() + ".dSYM/Contents/Resources/DWARF/" + exePath.getName());
            if (!dSymFile.exists()) {
                return null;
            }
            try (RandomAccessByteProvider provider = new RandomAccessByteProvider(dSymFile);){
                MachHeader header = new MachHeader(provider);
                header.parse();
                List<Section> allSections = header.getAllSections();
                for (Section section : allSections) {
                    if (!section.getSectionName().equals(sectionNames.SECTION_NAME_LINE())) continue;
                    InputStreamByteProvider inputStreamByteProvider = new InputStreamByteProvider(section.getDataStream(header), section.getSize());
                    return inputStreamByteProvider;
                }
                Iterator<Section> iterator = null;
                return iterator;
            }
            return null;
        }
        if ("Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            MemoryBlock block = program.getMemory().getBlock(sectionNames.SECTION_NAME_LINE());
            if (block != null) {
                return MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), block);
            }
            return null;
        }
        throw new IllegalArgumentException("Unrecognized program format: " + program.getExecutableFormat());
    }

    @Override
    public boolean canAnalyze(Program program) {
        return this.isElfOrMacho(program);
    }

    private boolean hasDebugInfo(Program program) {
        DwarfSectionNames sectionNames = new DwarfSectionNames(program);
        MemoryBlock block = null;
        block = program.getMemory().getBlock(sectionNames.SECTION_NAME_LINE());
        return block != null;
    }

    private boolean isElfOrMacho(Program program) {
        String format = program.getExecutableFormat();
        if ("Executable and Linking Format (ELF)".equals(format)) {
            return this.hasDebugInfo(program);
        }
        return "Mac OS X Mach-O".equals(format);
    }
}

