/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AIFFDataType;
import ghidra.program.model.data.AUDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GifDataType;
import ghidra.program.model.data.JPEGDataType;
import ghidra.program.model.data.PngDataType;
import ghidra.program.model.data.WAVEDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.bytesearch.GenericByteSequencePattern;
import ghidra.util.bytesearch.GenericMatchAction;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MemoryBytePatternSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class EmbeddedMediaAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Embedded Media";
    private static final String DESCRIPTION = "Finds embedded media data types (ie png, gif, jpeg, wav)";
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will be created at each location where embedded media data is identified.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;

    public EmbeddedMediaAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS);
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Memory memory = program.getMemory();
        AddressSetView validMemorySet = memory.getLoadedAndInitializedAddressSet();
        AddressSet searchSet = set.intersect(validMemorySet);
        if (searchSet.isEmpty()) {
            return false;
        }
        MemoryBytePatternSearcher searcher = new MemoryBytePatternSearcher(NAME);
        ArrayList<Address> foundMedia = new ArrayList<Address>();
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new GifDataType(), "GIF 87", GifDataType.MAGIC_87, GifDataType.GIFMASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new GifDataType(), "GIF 89", GifDataType.MAGIC_89, GifDataType.GIFMASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new PngDataType(), "PNG", PngDataType.MAGIC, PngDataType.MASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new JPEGDataType(), "JPEG", JPEGDataType.MAGIC, JPEGDataType.MAGIC_MASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new WAVEDataType(), "WAVE", WAVEDataType.MAGIC, WAVEDataType.MAGIC_MASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new AUDataType(), "AU", AUDataType.MAGIC, AUDataType.MAGIC_MASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new AIFFDataType(), "AIFF", AIFFDataType.MAGIC_AIFF, AIFFDataType.MAGIC_MASK);
        this.addByteSearchPattern(searcher, program, foundMedia, (DataType)new AIFFDataType(), "AIFC", AIFFDataType.MAGIC_AIFC, AIFFDataType.MAGIC_MASK);
        searcher.search(program, (AddressSetView)searchSet, monitor);
        return foundMedia.size() > 0;
    }

    private void addByteSearchPattern(MemoryBytePatternSearcher searcher, final Program program, final List<Address> foundMedia, final DataType mediaDT, final String mediaName, byte[] bytes, byte[] mask) {
        if (bytes == null) {
            return;
        }
        GenericMatchAction<DataType> action = new GenericMatchAction<DataType>(mediaDT){

            @Override
            public void apply(Program prog, Address addr, Match match) {
                if (!program.getListing().isUndefined(addr, addr)) {
                    return;
                }
                try {
                    CreateDataCmd cmd = new CreateDataCmd(addr, mediaDT);
                    if (cmd.applyTo((DomainObject)program)) {
                        if (EmbeddedMediaAnalyzer.this.createBookmarksEnabled) {
                            program.getBookmarkManager().setBookmark(addr, "Analysis", EmbeddedMediaAnalyzer.NAME, "Found " + mediaName + " Embedded Media");
                        }
                        foundMedia.add(addr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        GenericByteSequencePattern genericByteMatchPattern = new GenericByteSequencePattern(bytes, mask, action);
        searcher.addPattern(genericByteMatchPattern);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

