/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.Analyzer;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class OneShotAnalysisCommand
extends BackgroundCommand {
    private Analyzer analyzer;
    private AddressSetView set;
    private MessageLog log;

    public OneShotAnalysisCommand(Analyzer analyzer, AddressSetView set, MessageLog log) {
        super(analyzer.getName() + " - One Time", true, true, false);
        this.analyzer = analyzer;
        this.set = set;
        this.log = log;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        try {
            monitor.setMessage(this.analyzer.getName());
            return this.analyzer.added(program, this.set, monitor, this.log);
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public String getStatusMsg() {
        String statusMessage = this.log.getStatus();
        if (statusMessage.length() > 0) {
            return statusMessage;
        }
        return null;
    }
}

