/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.util.StringUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StoredAnalyzerTimes
implements CustomOption {
    public static final String OPTIONS_LIST = "Program Information.Analysis Times";
    public static final String OPTION_NAME = "Times";
    private Map<String, Long> taskTimes = new HashMap<String, Long>();
    private Long totalTime;
    private String[] names;

    public void readState(SaveState saveState) {
        this.taskTimes.clear();
        for (String taskName : saveState.getNames()) {
            if ("CUSTOM_OPTION_CLASS".equals(taskName)) continue;
            this.taskTimes.put(taskName, saveState.getLong(taskName, 0L));
        }
        this.names = null;
        this.totalTime = null;
    }

    public void writeState(SaveState saveState) {
        for (String taskName : this.taskTimes.keySet()) {
            saveState.putLong(taskName, this.taskTimes.get(taskName).longValue());
        }
    }

    public void clear() {
        this.taskTimes.clear();
        this.names = null;
        this.totalTime = null;
    }

    public boolean isEmpty() {
        return this.taskTimes.isEmpty();
    }

    public void clear(String taskName) {
        this.taskTimes.remove(taskName);
        this.names = null;
        this.totalTime = null;
    }

    public void addTime(String taskName, long t) {
        long cumulativeTime = this.taskTimes.getOrDefault(taskName, 0L) + t;
        this.taskTimes.put(taskName, cumulativeTime);
        this.names = null;
        this.totalTime = null;
    }

    public Long getTime(String taskName) {
        return this.taskTimes.get(taskName);
    }

    public long getTotalTime() {
        if (this.totalTime == null) {
            long sum = 0L;
            for (long t : this.taskTimes.values()) {
                sum += t;
            }
            this.totalTime = sum;
        }
        return this.totalTime;
    }

    public String toString() {
        return StoredAnalyzerTimes.formatTimeMS(this.getTotalTime()) + " seconds";
    }

    public String[] getTaskNames() {
        if (this.names == null) {
            this.names = this.taskTimes.keySet().toArray(new String[this.taskTimes.size()]);
            Arrays.sort(this.names);
        }
        return this.names;
    }

    public int hashCode() {
        return this.taskTimes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoredAnalyzerTimes)) {
            return false;
        }
        return this.taskTimes.equals(((StoredAnalyzerTimes)obj).taskTimes);
    }

    public StoredAnalyzerTimes clone() {
        StoredAnalyzerTimes newInstance = new StoredAnalyzerTimes();
        newInstance.taskTimes = new HashMap<String, Long>(this.taskTimes);
        return newInstance;
    }

    public static StoredAnalyzerTimes getStoredAnalyzerTimes(Program program) {
        Options options = program.getOptions(OPTIONS_LIST);
        StoredAnalyzerTimes times = (StoredAnalyzerTimes)options.getCustomOption(OPTION_NAME, (CustomOption)new StoredAnalyzerTimes());
        return times.clone();
    }

    public static void setStoredAnalyzerTimes(Program program, StoredAnalyzerTimes times) {
        Options options = program.getOptions(OPTIONS_LIST);
        options.putObject(OPTION_NAME, (Object)times);
    }

    static String formatTimeMS(long timeMS) {
        Object str = Long.toUnsignedString(timeMS / 1000L);
        str = (String)str + ".";
        str = (String)str + StringUtilities.pad((String)Long.toUnsignedString(timeMS % 1000L), (char)'0', (int)3);
        return str;
    }
}

