/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LazyMap;

public abstract class CallNode
extends GTreeSlowLoadingNode {
    private boolean allowDuplicates;
    protected AtomicInteger filterDepth;
    private int depth = -1;
    protected boolean invalid = false;

    public CallNode(AtomicInteger filterDepth) {
        this.filterDepth = filterDepth;
    }

    public abstract Function getRemoteFunction();

    public abstract ProgramLocation getLocation();

    public abstract Address getSourceAddress();

    abstract CallNode recreate();

    protected Set<Reference> getReferencesFrom(Program program, AddressSetView addresses, TaskMonitor monitor) throws CancelledException {
        HashSet<Reference> set = new HashSet<Reference>();
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator addressIterator = addresses.getAddresses(true);
        while (addressIterator.hasNext()) {
            monitor.checkCancelled();
            Address address = addressIterator.next();
            Reference[] referencesFrom = referenceManager.getReferencesFrom(address);
            if (referencesFrom == null) continue;
            for (Reference reference : referencesFrom) {
                set.add(reference);
            }
        }
        return set;
    }

    protected void setAllowsDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    protected void addNode(LazyMap<Function, List<GTreeNode>> nodesByFunction, CallNode node) {
        Function function = node.getRemoteFunction();
        List nodes = (List)nodesByFunction.get((Object)function);
        if (nodes.contains((Object)node)) {
            return;
        }
        if (this.allowDuplicates) {
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            nodes.add(node);
            return;
        }
    }

    public int loadAll(TaskMonitor monitor) throws CancelledException {
        if (this.depth() > this.filterDepth.get()) {
            return 1;
        }
        return super.loadAll(monitor);
    }

    private int depth() {
        if (this.depth < 0) {
            TreePath treePath = this.getTreePath();
            Object[] path = treePath.getPath();
            this.depth = path.length;
        }
        return this.depth;
    }

    boolean functionIsInPath() {
        Object[] pathComponents;
        TreePath path = this.getTreePath();
        for (Object pathComponent : pathComponents = path.getPath()) {
            CallNode node = (CallNode)((Object)pathComponent);
            Function nodeFunction = node.getRemoteFunction();
            Function myFunction = this.getRemoteFunction();
            if (node == this || !nodeFunction.equals(myFunction)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CallNode other = (CallNode)((Object)obj);
        if (!Objects.equals(this.getSourceAddress(), other.getSourceAddress())) {
            return false;
        }
        return Objects.equals(this.getRemoteFunction(), other.getRemoteFunction());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        Function function = this.getRemoteFunction();
        result = 31 * result + (function == null ? 0 : function.hashCode());
        Address sourceAddress = this.getSourceAddress();
        result = 31 * result + (sourceAddress == null ? 0 : sourceAddress.hashCode());
        return result;
    }

    protected class CallNodeComparator
    implements Comparator<GTreeNode> {
        protected CallNodeComparator() {
        }

        @Override
        public int compare(GTreeNode o1, GTreeNode o2) {
            return ((CallNode)o1).getSourceAddress().compareTo((Object)((CallNode)o2).getSourceAddress());
        }
    }
}

