/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.widgets.tree.support.GTreeNodeTransferable;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.util.List;

public class ClearCutAction
extends DockingAction {
    private Clipboard clipboard;

    public ClearCutAction(DataTypeManagerPlugin plugin) {
        super("Clear Cut", plugin.getName());
        this.clipboard = plugin.getClipboard();
        this.setKeyBindingData(new KeyBindingData(27, 0));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        Transferable transferable = this.clipboard.getContents((Object)this);
        if (transferable instanceof GTreeNodeTransferable) {
            GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
            List nodeList = gtTransferable.getAllData();
            if (nodeList.isEmpty()) {
                return;
            }
            DataTypeTreeNode node = (DataTypeTreeNode)((Object)nodeList.get(0));
            if (node.isCut()) {
                this.clipboard.setContents(null, null);
            }
        }
    }
}

