/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.InvalidNameException;
import javax.swing.tree.TreePath;

public class CreateCategoryAction
extends DockingAction {
    private static final String NEW_CATEGORY = "New Category";

    public CreateCategoryAction(DataTypeManagerPlugin plugin) {
        super(NEW_CATEGORY, plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"New", "Category"}, null, "Create"));
        this.setDescription("Creates a new Category.");
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        CategoryNode categoryNode = this.getSelectedCategoryNode(context);
        if (categoryNode == null || !categoryNode.isEnabled()) {
            return false;
        }
        return !(categoryNode instanceof BuiltInArchiveNode);
    }

    public boolean isEnabledForContext(ActionContext context) {
        CategoryNode categoryNode = this.getSelectedCategoryNode(context);
        return categoryNode != null && categoryNode.isModifiable();
    }

    private CategoryNode getSelectedCategoryNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof CategoryNode)) {
            return null;
        }
        return (CategoryNode)node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        CategoryNode node = (CategoryNode)((Object)selectionPaths[0].getLastPathComponent());
        Category category = node.getCategory();
        ArchiveNode archiveNode = node.getArchiveNode();
        Archive archive = archiveNode.getArchive();
        DataTypeManager dataTypeManager = archive.getDataTypeManager();
        String newNodeName = null;
        int transactionID = dataTypeManager.startTransaction("Create Category");
        try {
            newNodeName = this.getUniqueCategoryName(category);
            category.createCategory(newNodeName);
        }
        catch (InvalidNameException invalidNameException) {
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
        dataTypeManager.flushEvents();
        gtree.startEditing((GTreeNode)node, newNodeName);
    }

    private String getUniqueCategoryName(Category parent) {
        int index = 1;
        Object name = NEW_CATEGORY;
        Category category = parent.getCategory((String)name);
        while (category != null) {
            name = NEW_CATEGORY + index;
            ++index;
            category = parent.getCategory((String)name);
        }
        return name;
    }
}

