/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

class XRefLocationDescriptor
extends LocationDescriptor {
    XRefLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        this.program = program;
        this.init();
    }

    protected void init() {
        Address xrefAddress;
        this.validate();
        this.homeAddress = xrefAddress = this.getXRefAddress(this.programLocation);
        if (this.homeAddress == null) {
            throw new NullPointerException("Every location descriptor must have a valid home address");
        }
        if (xrefAddress == null) {
            this.label = this.getLabelForLocation(this.programLocation);
            return;
        }
        this.label = this.getLabelForLocation(this.programLocation);
    }

    protected void validate() {
        if (this.programLocation == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(this.programLocation instanceof XRefFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + this.programLocation);
        }
    }

    protected Address getXRefAddress(ProgramLocation location) {
        return ((XRefFieldLocation)location).getRefAddress();
    }

    protected String getLabelForLocation(ProgramLocation location) {
        Address refAddress = this.getXRefAddress(location);
        if (refAddress != null) {
            return refAddress.toString();
        }
        return location.toString();
    }

    @Override
    protected boolean isInAddresses(Address address) {
        return this.referencesContain(address);
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        ReferenceManager referenceManager = this.program.getReferenceManager();
        ReferenceIterator referencesToIterator = referenceManager.getReferencesTo(this.homeAddress);
        while (referencesToIterator.hasNext()) {
            accumulator.add((Object)new LocationReference(referencesToIterator.next(), false));
        }
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        Reference[] references = this.getAllReferencesBetweenAddresses(currentAddress, this.homeAddress);
        ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
        for (Reference reference : references) {
            this.getHighlightsForReference(reference, text, fieldFactoryClass, highlightList, highlightColor);
        }
        return highlightList.toArray(new Highlight[highlightList.size()]);
    }

    private void getHighlightsForReference(Reference reference, String text, Class<? extends FieldFactory> fieldFactoryClass, List<Highlight> highlightList, Color highlightColor) {
        int opIndex = reference.getOperandIndex();
        if (MnemonicFieldFactory.class.isAssignableFrom(fieldFactoryClass) && opIndex == -1) {
            highlightList.add(new Highlight(0, text.length() - 1, highlightColor));
        } else if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass) && opIndex > -1) {
            String[] parts = text.split(",");
            int offset = text.indexOf(parts[opIndex]);
            int length = parts[opIndex].length() - 1;
            highlightList.add(new Highlight(offset, length, highlightColor));
        }
    }

    private Reference[] getAllReferencesBetweenAddresses(Address fromAddress, Address toAddress) {
        ReferenceManager referenceManager = this.program.getReferenceManager();
        ReferenceIterator references = referenceManager.getReferencesTo(toAddress);
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        while (references.hasNext()) {
            Reference reference = references.next();
            if (!reference.getFromAddress().equals((Object)fromAddress)) continue;
            referenceList.add(reference);
        }
        return referenceList.toArray(new Reference[referenceList.size()]);
    }
}

