/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.cmd.refs.EditRefTypeCmd;
import ghidra.app.cmd.refs.SetPrimaryRefCmd;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.table.field.AddressBasedLocation;
import java.util.Arrays;
import java.util.List;

class EditReferencesModel
extends AbstractSortedTableModel<Reference> {
    static final String OPERAND = "Operand";
    static final String LOCATION = "Destination";
    static final String LABEL = "Label";
    static final String REF_TYPE = "Ref-Type";
    static final String IS_PRIMARY = "Primary?";
    static final String REF_SOURCE = "Source";
    static final int OPERAND_COL = 0;
    static final int LOCATION_COL = 1;
    static final int LABEL_COL = 2;
    static final int REF_TYPE_COL = 3;
    static final int IS_PRIMARY_COL = 4;
    static final int REF_SOURCE_COL = 5;
    static final int DEFAULT_SORT_COL = 0;
    private static final String[] COLUMN_NAMES = new String[]{"Operand", "Destination", "Label", "Ref-Type", "Primary?", "Source"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, AddressBasedLocation.class, String.class, RefType.class, Boolean.class, SourceType.class};
    private ReferencesPlugin plugin;
    private CodeUnit cu;
    private BrowserCodeUnitFormat cuFormat;
    private Reference[] refs = new Reference[0];

    EditReferencesModel(ReferencesPlugin plugin) {
        super(0);
        this.plugin = plugin;
        this.cuFormat = plugin.getCodeUnitFormat();
    }

    void setCodeUnitLocation(CodeUnit cu) {
        this.cu = cu;
        this.refs = cu == null ? new Reference[0] : cu.getReferencesFrom();
        this.fireTableDataChanged();
    }

    Program getProgram() {
        return this.cu != null ? this.cu.getProgram() : null;
    }

    public String getName() {
        return "Edit References";
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return this.refs.length;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 4 || columnIndex == 3) {
            if (rowIndex >= this.refs.length) {
                return false;
            }
            Address toAddr = this.refs[rowIndex].getToAddress();
            if (toAddr.isMemoryAddress()) {
                return true;
            }
            if (columnIndex == 3) {
                return true;
            }
        }
        return false;
    }

    public Object getColumnValueForRow(Reference reference, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                int opIndex = reference.getOperandIndex();
                if (opIndex == -1) {
                    return "MNEMONIC";
                }
                return "OP-" + opIndex;
            }
            case 1: {
                return new AddressBasedLocation(this.getProgram(), reference, this.cuFormat.getShowBlockName());
            }
            case 2: {
                return this.getToLabel(reference);
            }
            case 3: {
                return reference.getReferenceType();
            }
            case 4: {
                return reference.isPrimary();
            }
            case 5: {
                return reference.getSource();
            }
        }
        return null;
    }

    public List<Reference> getModelData() {
        return Arrays.asList(this.refs);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.refs.length) {
            return;
        }
        Reference ref = this.refs[rowIndex];
        switch (columnIndex) {
            case 3: {
                if (ref.getReferenceType() == value) break;
                EditRefTypeCmd cmd = new EditRefTypeCmd(ref, (RefType)value);
                this.plugin.getTool().execute((Command)cmd, (DomainObject)this.cu.getProgram());
                break;
            }
            case 4: {
                SetPrimaryRefCmd cmd = new SetPrimaryRefCmd(ref, (Boolean)value);
                this.plugin.getTool().execute((Command)cmd, (DomainObject)this.cu.getProgram());
                break;
            }
            default: {
                throw new RuntimeException("Column is not editable");
            }
        }
    }

    private String getToLabel(Reference ref) {
        if (this.cu == null) {
            return null;
        }
        return this.cuFormat.getReferenceRepresentationString(this.cu, ref);
    }

    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    int getRow(Reference ref) {
        for (int row = 0; row < this.refs.length; ++row) {
            if (this.refs[row].compareTo((Object)ref) != 0) continue;
            return row;
        }
        return -1;
    }

    Reference getReference(int row) {
        return row < this.refs.length ? this.refs[row] : null;
    }

    static RefType[] getAllowedRefTypes(Program program, Reference ref) {
        Address toAddr = ref.getToAddress();
        if (toAddr.isStackAddress()) {
            return RefTypeFactory.getStackRefTypes();
        }
        if (toAddr.isRegisterAddress()) {
            return RefTypeFactory.getDataRefTypes();
        }
        if (toAddr.isMemoryAddress()) {
            if (program.getAddressFactory().getDefaultAddressSpace() == toAddr.getAddressSpace() || EditReferencesModel.isComputedFlow(program, ref)) {
                return RefTypeFactory.getMemoryRefTypes();
            }
            return RefTypeFactory.getDataRefTypes();
        }
        if (toAddr.isExternalAddress()) {
            return RefTypeFactory.getExternalRefTypes();
        }
        throw new IllegalArgumentException("Unsupported reference");
    }

    private static boolean isComputedFlow(Program program, Reference ref) {
        Instruction instr = program.getListing().getInstructionAt(ref.getFromAddress());
        return instr != null && instr.getFlowType().isComputed();
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }
}

