/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.searchmem.SearchFormat;
import ghidra.util.HTMLUtilities;
import java.util.StringTokenizer;
import javax.swing.event.ChangeListener;

public class BinarySearchFormat
extends SearchFormat {
    private static final String VALID_CHARS = "01x?.";
    private String statusText;

    public BinarySearchFormat(ChangeListener listener) {
        super("Binary", listener);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret value as a sequence of binary digits.\nSpaces will start the next byte.  Bit sequences less\nthan 8 bits are padded with 0's to the left. \nEnter 'x', '.' or '?' for a wildcard bit");
    }

    @Override
    public SearchData getSearchData(String input) {
        StringTokenizer st = new StringTokenizer(input);
        int n = st.countTokens();
        byte[] bytes = new byte[n];
        byte[] mask = new byte[n];
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!this.isValidBinary(token)) {
                return SearchData.createInvalidInputSearchData(this.statusText);
            }
            bytes[index] = this.getByte(token);
            mask[index] = this.getMask(token);
            ++index;
        }
        return SearchData.createSearchData(input, bytes, mask);
    }

    private boolean isValidBinary(String str) {
        if (str.length() > 8) {
            this.statusText = "Max group size exceeded. Enter <space> to add more.";
            return false;
        }
        this.statusText = "";
        for (int i = 0; i < str.length(); ++i) {
            if (VALID_CHARS.indexOf(str.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    private byte getByte(String token) {
        byte b = 0;
        for (int i = 0; i < token.length(); ++i) {
            b = (byte)(b << 1);
            char c = token.charAt(i);
            if (c != '1') continue;
            b = (byte)(b | 1);
        }
        return b;
    }

    private byte getMask(String token) {
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            b = (byte)(b << 1);
            if (i < token.length()) {
                char c = token.charAt(i);
                if (c != '1' && c != '0') continue;
                b = (byte)(b | 1);
                continue;
            }
            b = (byte)(b | 1);
        }
        return b;
    }

    @Override
    public boolean usesEndieness() {
        return false;
    }
}

