/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.StringAddedEvent;
import ghidra.app.plugin.core.string.StringEvent;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.AlignmentDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramTask;
import ghidra.program.util.string.FoundString;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class MakeStringsTask
extends ProgramTask {
    private static final String LOCALIZATION_SEPARATOR = "@";
    private static final int MAX_LABEL_LENGTH = 60;
    private List<FoundString> foundStrings;
    private boolean autoLabel;
    private boolean addAlignmentBytes;
    private boolean allowTruncate;
    private int offset;
    private boolean hasErrors = false;
    private int alignment;
    private boolean makeArray;
    private List<StringEvent> events = new ArrayList<StringEvent>();

    public MakeStringsTask(Program program, List<FoundString> foundStrings, int offset, int alignment, boolean autoLabel, boolean addAlignmentBytes, boolean allowTruncate, boolean makeArray) {
        super(program, "Making Strings", true, true, true);
        this.foundStrings = foundStrings;
        this.offset = offset;
        this.alignment = alignment;
        this.autoLabel = autoLabel;
        this.addAlignmentBytes = addAlignmentBytes;
        this.allowTruncate = allowTruncate;
        this.makeArray = makeArray;
    }

    public MakeStringsTask(Program program, FoundString foundString, int offset, int alignment, boolean autoLabel, boolean addAlignmentBytes, boolean allowTruncate, boolean makeArray) {
        super(program, "Making Strings", true, true, true);
        ArrayList<FoundString> tempFoundStrings = new ArrayList<FoundString>();
        tempFoundStrings.add(foundString);
        this.foundStrings = tempFoundStrings;
        this.offset = offset;
        this.alignment = alignment;
        this.autoLabel = autoLabel;
        this.addAlignmentBytes = addAlignmentBytes;
        this.allowTruncate = allowTruncate;
        this.makeArray = makeArray;
    }

    public void doRun(TaskMonitor monitor) {
        monitor.initialize((long)this.foundStrings.size());
        for (FoundString foundString : this.foundStrings) {
            if (monitor.isCancelled()) break;
            this.makeString(foundString);
            monitor.incrementProgress(1L);
        }
    }

    private void makeString(FoundString foundString) {
        DataType stringInstanceDataType;
        StringDataInstance stringInstance = foundString.getDataInstance(this.program.getMemory());
        if (this.offset != 0) {
            stringInstance = stringInstance.getCharOffcut(this.offset);
        }
        if (stringInstance.getStringLength() == 0) {
            return;
        }
        Address address = stringInstance.getAddress();
        int length = stringInstance.getDataLength();
        int paddingLength = this.getPaddingLength(address, length);
        Address conflictingAddress = DataUtilities.findFirstConflictingAddress((Program)this.program, (Address)address, (int)length, (boolean)true);
        if (conflictingAddress != null) {
            if (!this.allowTruncate) {
                this.hasErrors = true;
                return;
            }
            length = (int)conflictingAddress.subtract(address);
            paddingLength = 0;
        }
        if (paddingLength > 0 && (conflictingAddress = DataUtilities.findFirstConflictingAddress((Program)this.program, (Address)address.add((long)length), (int)paddingLength, (boolean)true)) != null) {
            paddingLength = 0;
        }
        if (!this.isPascal(stringInstanceDataType = stringInstance.getStringDataTypeGuess())) {
            length += paddingLength;
            paddingLength = 0;
        }
        DataType dataTypeToCreate = stringInstanceDataType;
        if (this.makeArray && stringInstanceDataType instanceof AbstractStringDataType) {
            DataType elementDT = ((AbstractStringDataType)stringInstanceDataType).getReplacementBaseType();
            int elementCount = length / elementDT.getLength();
            dataTypeToCreate = new ArrayDataType(elementDT, elementCount, elementDT.getLength());
        }
        Data stringData = null;
        try {
            stringData = DataUtilities.createData((Program)this.program, (Address)address, (DataType)dataTypeToCreate, (int)length, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
            this.events.add(new StringAddedEvent(dataTypeToCreate, address, stringData.getLength()));
        }
        catch (Exception e) {
            this.hasErrors = true;
        }
        if (paddingLength != 0) {
            try {
                this.program.getListing().createData(address.add((long)length), (DataType)new AlignmentDataType(), paddingLength);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.autoLabel && stringData != null) {
            String labelString = dataTypeToCreate.getDefaultLabelPrefix((MemBuffer)stringData, (Settings)stringData, stringData.getLength(), DataTypeDisplayOptions.DEFAULT);
            this.createLabel(address, labelString);
        }
    }

    private boolean isPascal(DataType stringDataType) {
        return stringDataType instanceof PascalString255DataType || stringDataType instanceof PascalStringDataType || stringDataType instanceof PascalUnicodeDataType;
    }

    private void createLabel(Address addr, String label) {
        if (((String)label).length() > 60) {
            label = ((String)label).substring(0, 60) + LOCALIZATION_SEPARATOR + addr;
        }
        try {
            this.doCreateLabel(addr, (String)label);
            return;
        }
        catch (DuplicateNameException exc) {
            if (this.labelAlreadyExists(addr, (String)label)) {
                return;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        this.createLocalizedLabel(addr, (String)label);
    }

    private void createLocalizedLabel(Address addr, String label) {
        String validLabel = SymbolUtilities.replaceInvalidChars((String)label, (boolean)false);
        String localizedLabel = validLabel + LOCALIZATION_SEPARATOR + addr.toString();
        try {
            this.doCreateLabel(addr, localizedLabel);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (InvalidInputException e) {
            Msg.debug((Object)((Object)this), (Object)"Unexpected exception creating symbol", (Throwable)e);
        }
    }

    private void doCreateLabel(Address addr, String label) throws DuplicateNameException, InvalidInputException {
        Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
        if (sym == null) {
            this.program.getSymbolTable().createLabel(addr, label, SourceType.ANALYSIS);
        } else if (sym.getSource() == SourceType.DEFAULT) {
            sym.setName(label, SourceType.ANALYSIS);
        } else if (!sym.toString().equals(label)) {
            Symbol newSym = this.program.getSymbolTable().createLabel(addr, label, SourceType.ANALYSIS);
            newSym.setPrimary();
        }
    }

    private boolean labelAlreadyExists(Address addr, String name) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator symbols = symbolTable.getSymbolsAsIterator(addr);
        for (Symbol symbol : symbols) {
            if (!symbol.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private int getPaddingLength(Address address, int length) {
        if (!this.addAlignmentBytes || length % this.alignment == 0) {
            return 0;
        }
        int padLength = this.alignment - length % this.alignment;
        try {
            byte[] bytes = new byte[padLength];
            int num = this.program.getMemory().getBytes(address.add((long)length), bytes, 0, padLength);
            if (num != padLength) {
                return 0;
            }
            for (int i = 0; i < padLength; ++i) {
                if (bytes[i] == 0) continue;
                return 0;
            }
            return padLength;
        }
        catch (MemoryAccessException e1) {
            return 0;
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public List<StringEvent> getStringEvents() {
        return this.events;
    }
}

