/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.dbtable;

import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.debug.dbtable.AbstractColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BinaryColumnAdapter;
import ghidra.app.plugin.debug.dbtable.BooleanColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ByteColumnAdapter;
import ghidra.app.plugin.debug.dbtable.IntegerColumnAdapter;
import ghidra.app.plugin.debug.dbtable.LongColumnAdapter;
import ghidra.app.plugin.debug.dbtable.ShortColumnAdapter;
import ghidra.app.plugin.debug.dbtable.StringColumnAdapter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DbSmallTableModel
extends AbstractSortedTableModel<DBRecord> {
    private Table table;
    private Schema schema;
    private List<AbstractColumnAdapter> columns = new ArrayList<AbstractColumnAdapter>();
    private List<DBRecord> records;

    public DbSmallTableModel(Table table) {
        Field[] fields;
        this.table = table;
        this.schema = table.getSchema();
        this.records = new ArrayList<DBRecord>(table.getRecordCount());
        this.columns.add(this.getColumn(this.schema.getKeyFieldType()));
        for (Field field : fields = this.schema.getFields()) {
            this.columns.add(this.getColumn(field));
        }
        try {
            RecordIterator it = table.iterator();
            while (it.hasNext()) {
                this.records.add(it.next());
            }
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private AbstractColumnAdapter getColumn(Field field) {
        if (field instanceof ByteField) {
            return new ByteColumnAdapter();
        }
        if (field instanceof BooleanField) {
            return new BooleanColumnAdapter();
        }
        if (field instanceof ShortField) {
            return new ShortColumnAdapter();
        }
        if (field instanceof IntField) {
            return new IntegerColumnAdapter();
        }
        if (field instanceof LongField) {
            return new LongColumnAdapter();
        }
        if (field instanceof StringField) {
            return new StringColumnAdapter();
        }
        if (field instanceof BinaryField) {
            return new BinaryColumnAdapter();
        }
        throw new AssertException("New, unexpected DB column type: " + field.getClass().getSimpleName());
    }

    public String getName() {
        return "DB Small Table";
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getValueClass();
    }

    public int getColumnCount() {
        return this.schema.getFieldCount() + 1;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.schema.getKeyName();
        }
        --columnIndex;
        int[] indexCols = this.table.getIndexedColumns();
        boolean isIndexed = false;
        for (int indexCol : indexCols) {
            if (indexCol != columnIndex) continue;
            isIndexed = true;
            break;
        }
        return this.schema.getFieldNames()[columnIndex] + (isIndexed ? "*" : "");
    }

    public int getRowCount() {
        return this.table.getRecordCount();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getColumnValueForRow(DBRecord rec, int columnIndex) {
        if (columnIndex == 0) {
            return this.columns.get(columnIndex).getKeyValue(rec);
        }
        int dbColumn = columnIndex - 1;
        return this.columns.get(columnIndex).getValue(rec, dbColumn);
    }

    public List<DBRecord> getModelData() {
        return this.records;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }
}

