/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfNote;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NoteGnuProperty
extends ElfNote {
    public static final String SECTION_NAME = ".note.gnu.property";
    private static final int GNU_PROPERTY_STACK_SIZE = 1;
    private static final int GNU_PROPERTY_NO_COPY_ON_PROTECTED = 2;
    private static final int GNU_PROPERTY_LOPROC = -1073741824;
    private static final int GNU_PROPERTY_HIPROC = -536870913;
    private static final int GNU_PROPERTY_LOUSER = -536870912;
    private static final int GNU_PROPERTY_HIUSER = -1;
    private final List<NotePropertyElement> elements;

    public static NoteGnuProperty read(ElfNote note, Program program) throws IOException {
        ArrayList<NotePropertyElement> elements = new ArrayList<NotePropertyElement>();
        BinaryReader descReader = note.getDescriptionReader(!program.getMemory().isBigEndian());
        while (descReader.hasNext()) {
            NotePropertyElement element = NoteGnuProperty.readNextNotePropertyElement(descReader, program.getDefaultPointerSize());
            elements.add(element);
        }
        return new NoteGnuProperty(note.getNameLen(), note.getName(), note.getVendorType(), elements);
    }

    private static NotePropertyElement readNextNotePropertyElement(BinaryReader reader, int intSize) throws IOException {
        String typeName;
        int prType = reader.readNextInt();
        int prDatasz = reader.readNextUnsignedIntExact();
        long dataStart = reader.getPointerIndex();
        String value = "???";
        switch (prType) {
            case 1: {
                typeName = "stack_size";
                long tmp = reader.readNextUnsignedValue(intSize);
                value = "%d (0x%08x)".formatted(tmp, tmp);
                break;
            }
            case 2: {
                typeName = "no_copy_on_protected";
                value = "set";
                break;
            }
            default: {
                typeName = -1073741824 <= prType && prType <= -536870913 ? "processor opt 0x%08x".formatted(prType) : (-536870912 <= prType && prType <= -1 ? "app opt 0x%08x".formatted(prType) : "unknown opt 0x%08x".formatted(prType));
                if (prDatasz <= 0) break;
                byte[] valueBytes = reader.readNextByteArray(prDatasz);
                value = NumericUtilities.convertBytesToString((byte[])valueBytes, (String)" ");
            }
        }
        reader.setPointerIndex(dataStart + (long)prDatasz);
        reader.align(intSize);
        return new NotePropertyElement(prType, typeName, value, prDatasz);
    }

    public static NoteGnuProperty fromProgram(Program program) {
        return ElfNote.readFromProgramHelper(program, SECTION_NAME, NoteGnuProperty::read);
    }

    public NoteGnuProperty(int nameLen, String name, int vendorType, List<NotePropertyElement> elements) {
        super(nameLen, name, vendorType);
        this.elements = elements;
    }

    @Override
    public String getNoteTypeName() {
        return SECTION_NAME;
    }

    @Override
    public void decorateProgramInfo(Options programInfoOptions) {
        for (NotePropertyElement element : this.elements) {
            String key = "ELF GNU Program Prop[%s]".formatted(element.typeName).replaceAll("\\.", "_");
            programInfoOptions.setString(key, element.value);
        }
    }

    @Override
    public void markupProgram(Program program, Address address) {
        super.markupProgram(program, address);
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        Listing listing = program.getListing();
        try {
            StructureDataType struct = NoteGnuProperty.createNoteStructure(null, "NoteGnuProperty_%d".formatted(this.getNameLen()), false, this.getNameLen(), 0, (DataTypeManager)program.getDataTypeManager());
            Data propData = DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            address = propData.getMaxAddress().next();
            for (NotePropertyElement element : this.elements) {
                DataType elementDT = this.getElementDataType((DataTypeManager)dtm, element);
                Data elementData = DataUtilities.createData((Program)program, (Address)address, (DataType)elementDT, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                listing.setComment(address, 0, element.typeName() + "=" + element.value());
                address = elementData.getMaxAddress().next();
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup NoteGnuProperty at %s, %s".formatted(address, this));
        }
    }

    private DataType getElementDataType(DataTypeManager dtm, NotePropertyElement element) {
        StructureDataType result = new StructureDataType("NoteGnuPropertyElement_%d".formatted(element.length()), 0, dtm);
        result.add(StructConverter.DWORD, "prType", null);
        result.add(StructConverter.DWORD, "prDatasz", null);
        result.add((DataType)new ArrayDataType(StructConverter.BYTE, element.length, -1, dtm), "data", null);
        return result;
    }

    @Override
    public StructureDataType toStructure(DataTypeManager dtm) {
        return null;
    }

    public record NotePropertyElement(int type, String typeName, String value, int length) {
    }
}

