/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.plugin.core.analysis.GolangSymbolAnalyzer;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.GoFunctionFixup;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPointProperties;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.List;

@ExtensionPointProperties(priority=4000)
public class GolangDWARFFunctionFixup
implements DWARFFunctionFixup {
    public static final CategoryPath GOLANG_API_EXPORT = new CategoryPath(CategoryPath.ROOT, new String[]{"GolangAPIExport"});
    private static final String GOLANG_ZEROBASE_ADDR = "GOLANG_ZEROBASE_ADDR";

    public static boolean isGolangFunction(DWARFFunction dfunc) {
        DIEAggregate diea = dfunc.diea;
        int cuLang = diea.getCompilationUnit().getCompileUnit().getLanguage();
        if (cuLang != 22) {
            return false;
        }
        return dfunc.retval.type.isEquivalent((DataType)VoidDataType.dataType);
    }

    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc, Function gfunc) {
        if (!GolangDWARFFunctionFixup.isGolangFunction(dfunc)) {
            return;
        }
        GoVer goVersion = this.getGolangVersion(dfunc);
        if (goVersion == GoVer.UNKNOWN) {
            return;
        }
        ProgramBasedDataTypeManager dtm = gfunc.getProgram().getDataTypeManager();
        GoParamStorageAllocator storageAllocator = new GoParamStorageAllocator(gfunc.getProgram(), goVersion);
        if (GoFunctionFixup.isGolangAbi0Func(gfunc)) {
            storageAllocator.setAbi0Mode();
            dfunc.prototypeModel = storageAllocator.getAbi0CallingConvention();
        } else {
            dfunc.prototypeModel = storageAllocator.getAbiInternalCallingConvention();
        }
        GoFunctionMultiReturn multiReturnInfo = this.fixupFormalFuncDef(dfunc, storageAllocator, (DataTypeManager)dtm);
        this.fixupCustomStorage(dfunc, gfunc, storageAllocator, (DataTypeManager)dtm, multiReturnInfo);
    }

    private GoFunctionMultiReturn fixupFormalFuncDef(DWARFFunction dfunc, GoParamStorageAllocator storageAllocator, DataTypeManager dtm) {
        ArrayList<DWARFVariable> realParams = new ArrayList<DWARFVariable>();
        ArrayList<DWARFVariable> returnParams = new ArrayList<DWARFVariable>();
        for (DWARFVariable dvar : dfunc.params) {
            if (dvar.isOutputParameter) {
                returnParams.add(dvar);
                continue;
            }
            realParams.add(dvar);
        }
        VoidDataType returnType = VoidDataType.dataType;
        GoFunctionMultiReturn multiReturn = null;
        if (returnParams.size() == 1) {
            returnType = ((DWARFVariable)returnParams.get((int)0)).type;
        } else if (returnParams.size() > 1) {
            multiReturn = new GoFunctionMultiReturn(returnParams, dfunc, dtm, storageAllocator);
            returnType = multiReturn.getStruct();
        }
        dfunc.retval = DWARFVariable.fromDataType(dfunc, (DataType)returnType);
        dfunc.params = realParams;
        dfunc.varArg = false;
        return multiReturn;
    }

    private void fixupCustomStorage(DWARFFunction dfunc, Function gfunc, GoParamStorageAllocator storageAllocator, DataTypeManager dtm, GoFunctionMultiReturn multiReturn) {
        ArrayList<DWARFVariable> spillVars = new ArrayList<DWARFVariable>();
        for (DWARFVariable dvar : dfunc.params) {
            List<Register> regStorage = storageAllocator.getRegistersFor(dvar.type);
            if (regStorage != null && !regStorage.isEmpty()) {
                dvar.setRegisterStorage(regStorage);
                spillVars.add(dvar);
                if (!(dvar.type instanceof Structure) || dvar.getStorageSize() == dvar.type.getLength()) continue;
                Msg.warn(GoFunctionFixup.class, (Object)"Known storage allocation problem: func %s@%s param %s register allocation for structs missing inter-field padding.".formatted(dfunc.name.getName(), dfunc.address, dvar.name.getName()));
                continue;
            }
            if (!dvar.isZeroByte()) {
                long stackOffset = storageAllocator.getStackAllocation(dvar.type);
                dvar.setStackStorage(stackOffset);
                continue;
            }
            if (dvar.isEmptyArray()) {
                dvar.type = GoFunctionFixup.makeEmptyArrayDataType(dvar.type);
            }
            Address zerobaseAddress = this.getZerobaseAddress(dfunc);
            dvar.setRamStorage(zerobaseAddress.getOffset());
        }
        storageAllocator.alignStack();
        storageAllocator.resetRegAllocation();
        if (!dfunc.retval.isZeroByte()) {
            dfunc.retval.clearStorage();
            if (multiReturn != null) {
                for (DataTypeComponent dtc : multiReturn.getNormalStorageComponents()) {
                    this.allocateReturnStorage(dfunc, dfunc.retval, dtc.getFieldName() + "-return-result-alias", dtc.getDataType(), storageAllocator, false);
                }
                for (DataTypeComponent dtc : multiReturn.getStackStorageComponents()) {
                    this.allocateReturnStorage(dfunc, dfunc.retval, dtc.getFieldName() + "-return-result-alias", dtc.getDataType(), storageAllocator, false);
                }
                Program program = gfunc.getProgram();
                if (!program.getMemory().isBigEndian()) {
                    List<Varnode> varnodes = dfunc.retval.getVarnodes();
                    GoFunctionFixup.reverseNonStackStorageLocations(varnodes);
                    dfunc.retval.setVarnodes(varnodes);
                }
            } else {
                this.allocateReturnStorage(dfunc, dfunc.retval, "return-value-alias-variable", dfunc.retval.type, storageAllocator, true);
            }
        } else {
            if (dfunc.retval.isEmptyArray()) {
                dfunc.retval.type = GoFunctionFixup.makeEmptyArrayDataType(dfunc.retval.type);
            }
            if (!dfunc.retval.isVoidType()) {
                dfunc.retval.setRamStorage(this.getZerobaseAddress(dfunc).getOffset());
            }
        }
        storageAllocator.alignStack();
        for (DWARFVariable dvar : spillVars) {
            DWARFVariable spill = DWARFVariable.fromDataType(dfunc, dvar.type);
            String paramName = dvar.name.getName() + "-spill";
            spill.name = dvar.name.replaceName(paramName, paramName);
            spill.setStackStorage(storageAllocator.getStackAllocation(spill.type));
            dfunc.localVars.add(spill);
        }
        dfunc.localVarErrors = false;
        dfunc.signatureCommitMode = DWARFFunction.CommitMode.STORAGE;
    }

    private void allocateReturnStorage(DWARFFunction dfunc, DWARFVariable dvar, String name, DataType dt, GoParamStorageAllocator storageAllocator, boolean allowEndianFixups) {
        List<Register> regStorage = storageAllocator.getRegistersFor(dt, allowEndianFixups);
        if (regStorage != null && !regStorage.isEmpty()) {
            dvar.addRegisterStorage(regStorage);
        } else if (!DWARFUtil.isZeroByteDataType(dt)) {
            long stackOffset = storageAllocator.getStackAllocation(dt);
            dvar.addStackStorage(stackOffset, dt.getLength());
            dfunc.localVars.add(this.createReturnResultAliasVar(dfunc, dt, name, stackOffset));
        }
    }

    private DWARFVariable createReturnResultAliasVar(DWARFFunction dfunc, DataType dataType, String name, long stackOffset) {
        DWARFVariable returnResultVar = DWARFVariable.fromDataType(dfunc, dataType);
        returnResultVar.name = dfunc.name.createChild(name, name, SymbolType.LOCAL_VAR);
        returnResultVar.setStackStorage(stackOffset);
        return returnResultVar;
    }

    private void exportOrigFuncDef(DWARFFunction dfunc, DataTypeManager dtm) {
        try {
            FunctionDefinition funcDef = dfunc.asFuncDef();
            funcDef.setCategoryPath(GOLANG_API_EXPORT);
            dtm.addDataType((DataType)funcDef, DataTypeConflictHandler.KEEP_HANDLER);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    private GoVer getGolangVersion(DWARFFunction dfunc) {
        DWARFProgram dprog = dfunc.getProgram();
        GoVer ver = dprog.getOpaqueProperty(GoVer.class, null, GoVer.class);
        if (ver == null) {
            GoBuildInfo goBuildInfo = GoBuildInfo.fromProgram(dprog.getGhidraProgram());
            ver = goBuildInfo != null ? goBuildInfo.getVerEnum() : GoVer.UNKNOWN;
            dprog.setOpaqueProperty(GoVer.class, (Object)ver);
        }
        return ver;
    }

    private Address getZerobaseAddress(DWARFFunction dfunc) {
        DWARFProgram dprog = dfunc.getProgram();
        Address zerobaseAddr = dprog.getOpaqueProperty(GOLANG_ZEROBASE_ADDR, null, Address.class);
        if (zerobaseAddr == null) {
            zerobaseAddr = GolangSymbolAnalyzer.getZerobaseAddress(dprog.getGhidraProgram());
            dprog.setOpaqueProperty(GOLANG_ZEROBASE_ADDR, zerobaseAddr);
        }
        return zerobaseAddr;
    }
}

