/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.info.ElfNote;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class NoteGoBuildId
extends ElfNote {
    public static final String SECTION_NAME = ".note.go.buildid";

    public static NoteGoBuildId read(BinaryReader br, Program unusedProgram) throws IOException {
        ElfNote note = ElfNote.read(br);
        if (!"Go".equals(note.getName())) {
            throw new IOException("Invalid note name: %s".formatted(note.getName()));
        }
        return new NoteGoBuildId(note.getNameLen(), note.getName(), note.getVendorType(), note.getDescription());
    }

    public NoteGoBuildId(int nameLen, String name, int vendorType, byte[] description) {
        super(nameLen, name, vendorType, description);
    }

    public String getBuildId() {
        return new String(this.getDescription(), StandardCharsets.UTF_8);
    }

    @Override
    public String getNoteTypeName() {
        return SECTION_NAME;
    }

    @Override
    public String getProgramInfoKey() {
        return "Golang BuildId";
    }

    @Override
    public String getNoteValueString() {
        return this.getBuildId();
    }

    @Override
    public StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType struct = ElfNote.createNoteStructure(GoConstants.GOLANG_CATEGORYPATH, "NoteGoBuildId_%d".formatted(this.description.length), false, this.nameLen, 0, dtm);
        struct.add((DataType)StringUTF8DataType.dataType, this.description.length, "BuildId", null);
        return struct;
    }
}

