/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime.maptype")
public class GoMapType
extends GoType {
    @FieldMapping
    private long key;
    @FieldMapping
    private long elem;
    @FieldMapping
    private long bucket;
    @FieldMapping
    private long hasher;
    @FieldMapping
    private int keysize;
    @FieldMapping
    private int elemsize;
    @FieldMapping
    private int bucketsize;
    @FieldMapping
    private int flags;

    @Markup
    public GoType getKey() throws IOException {
        return this.programContext.getGoType(this.key);
    }

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Markup
    public GoType getBucket() throws IOException {
        return this.programContext.getGoType(this.bucket);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoType mapGoType = this.programContext.getMapGoType();
        if (mapGoType == null) {
            return this.programContext.getDTM().getPointer(null);
        }
        DataType mapDT = mapGoType.recoverDataType();
        Pointer ptrMapDt = this.programContext.getDTM().getPointer(mapDT);
        if (this.typ.getSize() != (long)ptrMapDt.getLength()) {
            Msg.warn((Object)this, (Object)"Size mismatch between map type and recovered type");
        }
        TypedefDataType typedef = new TypedefDataType(this.programContext.getRecoveredTypesCp(), this.getStructureName(), (DataType)ptrMapDt, this.programContext.getDTM());
        return typedef;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType keyType = this.getKey();
        GoType elemType = this.getElement();
        GoType bucketType = this.getBucket();
        if (keyType != null) {
            keyType.discoverGoTypes(discoveredTypes);
        }
        if (elemType != null) {
            elemType.discoverGoTypes(discoveredTypes);
        }
        if (bucketType != null) {
            bucketType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

