/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LinkEditDataCommand
extends LoadCommand {
    protected int dataoff;
    protected int datasize;
    protected BinaryReader dataReader;

    LinkEditDataCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader);
        this.dataoff = loadCommandReader.readNextInt();
        this.datasize = loadCommandReader.readNextInt();
        this.dataReader = dataReader;
        this.dataReader.setPointerIndex(this.dataoff);
    }

    public int getDataOffset() {
        return this.dataoff;
    }

    public int getDataSize() {
        return this.datasize;
    }

    @Override
    public String getCommandName() {
        return "linkedit_data_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
                api.setPlateComment(address, LoadCommandTypes.getLoadCommandName(this.getCommandType()));
                if (this.datasize > 0) {
                    Address start = baseAddress.getNewAddress((long)this.dataoff);
                    api.createFragment(parentModule, this.getCommandName() + "_DATA", start, this.datasize);
                }
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "dataoff", null);
        struct.add(DWORD, "datasize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

