/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import java.lang.reflect.Field;

public final class LoadCommandTypes {
    public static final int LC_REQ_DYLD = Integer.MIN_VALUE;
    public static final int LC_SEGMENT = 1;
    public static final int LC_SYMTAB = 2;
    public static final int LC_SYMSEG = 3;
    public static final int LC_THREAD = 4;
    public static final int LC_UNIXTHREAD = 5;
    public static final int LC_LOADFVMLIB = 6;
    public static final int LC_IDFVMLIB = 7;
    public static final int LC_IDENT = 8;
    public static final int LC_FVMFILE = 9;
    public static final int LC_PREPAGE = 10;
    public static final int LC_DYSYMTAB = 11;
    public static final int LC_LOAD_DYLIB = 12;
    public static final int LC_ID_DYLIB = 13;
    public static final int LC_LOAD_DYLINKER = 14;
    public static final int LC_ID_DYLINKER = 15;
    public static final int LC_PREBOUND_DYLIB = 16;
    public static final int LC_ROUTINES = 17;
    public static final int LC_SUB_FRAMEWORK = 18;
    public static final int LC_SUB_UMBRELLA = 19;
    public static final int LC_SUB_CLIENT = 20;
    public static final int LC_SUB_LIBRARY = 21;
    public static final int LC_TWOLEVEL_HINTS = 22;
    public static final int LC_PREBIND_CKSUM = 23;
    public static final int LC_LOAD_WEAK_DYLIB = -2147483624;
    public static final int LC_SEGMENT_64 = 25;
    public static final int LC_ROUTINES_64 = 26;
    public static final int LC_UUID = 27;
    public static final int LC_RPATH = -2147483620;
    public static final int LC_CODE_SIGNATURE = 29;
    public static final int LC_SEGMENT_SPLIT_INFO = 30;
    public static final int LC_REEXPORT_DYLIB = -2147483617;
    public static final int LC_LAZY_LOAD_DYLIB = 32;
    public static final int LC_ENCRYPTION_INFO = 33;
    public static final int LC_DYLD_INFO = 34;
    public static final int LC_DYLD_INFO_ONLY = -2147483614;
    public static final int LC_LOAD_UPWARD_DYLIB = -2147483613;
    public static final int LC_VERSION_MIN_MACOSX = 36;
    public static final int LC_VERSION_MIN_IPHONEOS = 37;
    public static final int LC_FUNCTION_STARTS = 38;
    public static final int LC_DYLD_ENVIRONMENT = 39;
    public static final int LC_MAIN = -2147483608;
    public static final int LC_DATA_IN_CODE = 41;
    public static final int LC_SOURCE_VERSION = 42;
    public static final int LC_DYLIB_CODE_SIGN_DRS = 43;
    public static final int LC_ENCRYPTION_INFO_64 = 44;
    public static final int LC_LINKER_OPTIONS = 45;
    public static final int LC_OPTIMIZATION_HINT = 46;
    public static final int LC_VERSION_MIN_TVOS = 47;
    public static final int LC_VERSION_MIN_WATCHOS = 48;
    public static final int LC_NOTE = 49;
    public static final int LC_BUILD_VERSION = 50;
    public static final int LC_DYLD_EXPORTS_TRIE = -2147483597;
    public static final int LC_DYLD_CHAINED_FIXUPS = -2147483596;
    public static final int LC_FILESET_ENTRY = -2147483595;

    public static final String getLoadCommandName(int type) {
        for (Field field : LoadCommandTypes.class.getDeclaredFields()) {
            if (!field.getName().startsWith("LC_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (type != value) continue;
                return field.getName();
            }
            catch (Exception e) {
                break;
            }
        }
        return "Unknown load command type: " + Integer.toHexString(type);
    }
}

