/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAccelerateInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsEntry;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DyldCacheLocalSymbolsInfo
implements StructConverter {
    private int nlistOffset;
    private int nlistCount;
    private int stringsOffset;
    private int stringsSize;
    private int entriesOffset;
    private int entriesCount;
    private BinaryReader reader;
    private long startIndex;
    private List<NList> nlistList;
    private List<DyldCacheLocalSymbolsEntry> localSymbolsEntryList;
    private boolean is32bit;

    public DyldCacheLocalSymbolsInfo(BinaryReader reader, DyldArchitecture architecture) throws IOException {
        this.reader = reader;
        this.startIndex = reader.getPointerIndex();
        this.nlistOffset = reader.readNextInt();
        this.nlistCount = reader.readNextInt();
        this.stringsOffset = reader.readNextInt();
        this.stringsSize = reader.readNextInt();
        this.entriesOffset = reader.readNextInt();
        this.entriesCount = reader.readNextInt();
        this.nlistList = new ArrayList<NList>(this.nlistCount);
        this.localSymbolsEntryList = new ArrayList<DyldCacheLocalSymbolsEntry>(this.entriesCount);
        this.is32bit = architecture.getCpuType() != 0x100000C && architecture.getCpuType() != 0x1000007;
    }

    public void parse(MessageLog log, TaskMonitor monitor) throws CancelledException {
        this.parseNList(log, monitor);
        this.parseLocalSymbols(log, monitor);
    }

    public void markup(Program program, Address localSymbolsInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupLocalSymbols(program, localSymbolsInfoAddr, monitor, log);
    }

    public List<NList> getNList() {
        return this.nlistList;
    }

    public List<DyldCacheLocalSymbolsEntry> getLocalSymbolsEntries() {
        return this.localSymbolsEntryList;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_local_symbols_info", 0);
        struct.add(DWORD, "nlistOffset", "offset into this chunk of nlist entries");
        struct.add(DWORD, "nlistCount", "count of nlist entries");
        struct.add(DWORD, "stringsOffset", "offset into this chunk of string pool");
        struct.add(DWORD, "stringsSize", "byte count of string pool");
        struct.add(DWORD, "entriesOffset", "offset into this chunk of array of dyld_cache_local_symbols_entry ");
        struct.add(DWORD, "entriesCount", "number of elements in dyld_cache_local_symbols_entry array");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private void parseNList(MessageLog log, TaskMonitor monitor) throws CancelledException {
        BinaryReader nListReader = new BinaryReader(this.reader.getByteProvider(), this.reader.isLittleEndian());
        monitor.setMessage("Parsing DYLD local symbol nlists...");
        monitor.initialize((long)(this.nlistCount * 2));
        nListReader.setPointerIndex(this.startIndex + (long)this.nlistOffset);
        try {
            for (int i = 0; i < this.nlistCount; ++i) {
                this.nlistList.add(new NList(nListReader, this.is32bit));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
            List sortedList = this.nlistList.stream().sorted((o1, o2) -> Integer.compare(o1.getStringTableIndex(), o2.getStringTableIndex())).collect(Collectors.toList());
            long stringTableOffset = this.startIndex + (long)this.stringsOffset;
            for (NList nList : sortedList) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                nList.initString(nListReader, stringTableOffset);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse nlist.");
        }
    }

    private void parseLocalSymbols(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD local symbol entries...");
        monitor.initialize((long)this.entriesCount);
        this.reader.setPointerIndex(this.startIndex + (long)this.entriesOffset);
        try {
            for (int i = 0; i < this.entriesCount; ++i) {
                this.localSymbolsEntryList.add(new DyldCacheLocalSymbolsEntry(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse dyld_cache_local_symbols_entry.");
        }
    }

    private void markupNList(Program program, Address localSymbolsInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD local symbol nlists...");
        monitor.initialize((long)this.nlistCount);
        try {
            Address addr = localSymbolsInfoAddr.add((long)this.nlistOffset);
            for (NList nlist : this.nlistList) {
                Data d = program.getListing().createData(addr, nlist.toDataType());
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup nlist.");
        }
    }

    private void markupLocalSymbols(Program program, Address localSymbolsInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD local symbol entries...");
        monitor.initialize((long)this.entriesCount);
        try {
            Address addr = localSymbolsInfoAddr.add((long)this.entriesOffset);
            for (DyldCacheLocalSymbolsEntry localSymbolsEntry : this.localSymbolsEntryList) {
                Data d = program.getListing().createData(addr, localSymbolsEntry.toDataType());
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dyld_cache_local_symbols_entry.");
        }
    }
}

