/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ImportByName;
import ghidra.app.util.bin.format.pe.ImportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.ThunkData;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DelayImportDescriptor
implements StructConverter {
    public static final String NAME = "ImgDelayDescr";
    private int grAttrs;
    private long szName;
    private long phmod;
    private long pIAT;
    private long pINT;
    private long pBoundIAT;
    private long pUnloadIAT;
    private int dwTimeStamp;
    private String dllName;
    private List<ThunkData> thunksIAT = new ArrayList<ThunkData>();
    private List<ThunkData> thunksINT = new ArrayList<ThunkData>();
    private List<ThunkData> thunksBoundIAT = new ArrayList<ThunkData>();
    private List<ThunkData> thunksUnloadIAT = new ArrayList<ThunkData>();
    private List<ImportInfo> delayImportInfoList = new ArrayList<ImportInfo>();
    private Map<ThunkData, ImportByName> importByNameMap = new HashMap<ThunkData, ImportByName>();
    private boolean isValid;

    DelayImportDescriptor(NTHeader ntHeader, BinaryReader reader, int index) throws IOException {
        if (!ntHeader.checkPointer(index)) {
            Msg.error((Object)this, (Object)("Invalid file index for " + Integer.toHexString(index)));
            return;
        }
        this.readFields(reader, index);
        this.readName(ntHeader, reader);
        this.thunksIAT = this.readThunks(ntHeader, reader, this.pIAT, false);
        if (this.thunksIAT == null) {
            return;
        }
        this.thunksINT = this.readThunks(ntHeader, reader, this.pINT, true);
        if (this.thunksINT == null) {
            return;
        }
        this.thunksBoundIAT = this.readThunks(ntHeader, reader, this.pBoundIAT, false);
        if (this.thunksBoundIAT == null) {
            return;
        }
        this.thunksUnloadIAT = this.readThunks(ntHeader, reader, this.pUnloadIAT, false);
        if (this.thunksUnloadIAT == null) {
            return;
        }
        this.isValid = true;
    }

    private List<ThunkData> readThunks(NTHeader ntHeader, BinaryReader reader, long ptr, boolean isName) throws IOException {
        ArrayList<ThunkData> thunkList = new ArrayList<ThunkData>();
        if (ptr == 0L) {
            return thunkList;
        }
        long thunkPtr = 0L;
        int offset = 0;
        thunkPtr = this.isUsingRVA() ? ntHeader.rvaToPointer(ptr) : ntHeader.vaToPointer(ptr);
        while (true) {
            Object funcName;
            if (!ntHeader.checkPointer(thunkPtr)) {
                Msg.error((Object)this, (Object)("Invalid thunkPtr for " + Long.toHexString(ptr)));
                return null;
            }
            ThunkData thunk = new ThunkData(reader, (int)thunkPtr, ntHeader.getOptionalHeader().is64bit());
            thunkList.add(thunk);
            if (thunk.getAddressOfData() == 0L) break;
            thunkPtr += (long)thunk.getStructSize();
            if (!isName) continue;
            if (thunk.isOrdinal()) {
                funcName = "Ordinal_" + thunk.getOrdinal();
            } else {
                long ibnPtr = 0L;
                ibnPtr = this.isUsingRVA() ? ntHeader.rvaToPointer(thunk.getAddressOfData()) : ntHeader.vaToPointer(thunk.getAddressOfData());
                if (ibnPtr < 0L) {
                    Msg.error((Object)this, (Object)("Invalid import pointer for " + thunk.getAddressOfData()));
                    return thunkList;
                }
                ImportByName ibn = new ImportByName(reader, (int)ibnPtr);
                this.importByNameMap.put(thunk, ibn);
                funcName = ibn.getName();
                thunk.setImportByName(ibn);
            }
            this.delayImportInfoList.add(new ImportInfo(offset, "", this.dllName, (String)funcName, false));
            offset += thunk.getStructSize();
        }
        return thunkList;
    }

    private void readName(NTHeader ntHeader, BinaryReader reader) throws IOException {
        long namePtr;
        if (this.szName == 0L) {
            return;
        }
        long l = namePtr = this.isUsingRVA() ? ntHeader.rvaToPointer(this.szName) : ntHeader.vaToPointer(this.szName);
        if (!ntHeader.checkPointer(namePtr)) {
            Msg.warn((Object)this, (Object)("Invalid namePtr for " + Long.toHexString(this.szName)));
            return;
        }
        this.dllName = reader.readAsciiString((int)namePtr);
    }

    private void readFields(BinaryReader reader, int index) throws IOException {
        this.grAttrs = reader.readInt(index);
        this.szName = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.phmod = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.pIAT = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.pINT = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.pBoundIAT = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.pUnloadIAT = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
        this.dwTimeStamp = reader.readInt(index += 4);
        index += 4;
    }

    public boolean isUsingRVA() {
        return (this.grAttrs & 1) == 1;
    }

    public int getAttibutes() {
        return this.grAttrs;
    }

    public long getPointerToDLLName() {
        return this.szName;
    }

    public long getAddressOfModuleHandle() {
        return this.phmod;
    }

    public long getAddressOfIAT() {
        return this.pIAT;
    }

    public long getAddressOfINT() {
        return this.pINT;
    }

    public long getAddressOfBoundIAT() {
        return this.pBoundIAT;
    }

    public long getAddressOfOriginalIAT() {
        return this.pUnloadIAT;
    }

    public int getTimeStamp() {
        return this.dwTimeStamp;
    }

    public String getDLLName() {
        return this.dllName;
    }

    public Map<ThunkData, ImportByName> getImportByNameMap() {
        return new HashMap<ThunkData, ImportByName>(this.importByNameMap);
    }

    public List<ImportInfo> getImportList() {
        return new ArrayList<ImportInfo>(this.delayImportInfoList);
    }

    public List<ThunkData> getThunksIAT() {
        return new ArrayList<ThunkData>(this.thunksIAT);
    }

    public List<ThunkData> getThunksINT() {
        return new ArrayList<ThunkData>(this.thunksINT);
    }

    public List<ThunkData> getThunksBoundIAT() {
        return new ArrayList<ThunkData>(this.thunksBoundIAT);
    }

    public List<ThunkData> getThunksUnloadIAT() {
        return new ArrayList<ThunkData>(this.thunksUnloadIAT);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        IBO32DataType ibo32 = new IBO32DataType();
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "grAttrs", null);
        struct.add((DataType)ibo32, "szName", null);
        struct.add((DataType)ibo32, "phmod", null);
        struct.add((DataType)ibo32, "pIAT", null);
        struct.add((DataType)ibo32, "pINT", null);
        struct.add((DataType)ibo32, "pBoundIAT", null);
        struct.add((DataType)ibo32, "pUnloadIAT", null);
        struct.add(DWORD, "dwTimeStamp", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public int sizeof() {
        return 32;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

