/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.util.exception.AssertException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DefExportLine {
    private Pattern EXPORT_LINE_PATTERN = Pattern.compile("\\s*(\\w+)(\\s@\\d+)?(\\s\\w+)?");
    private String name;
    private int ordinal;
    private String type;

    DefExportLine(String exportLine) {
        String privateString;
        Matcher matcher = this.EXPORT_LINE_PATTERN.matcher(exportLine);
        if (!matcher.matches()) {
            throw new AssertException("Unexpected '.def' file line format.  Expected 'Name [@number] [PRIVATE]'; found " + exportLine);
        }
        this.name = matcher.group(1);
        String ordinalString = matcher.group(2);
        if (ordinalString != null) {
            ordinalString = ordinalString.trim().substring(1);
            this.ordinal = Integer.parseInt(ordinalString);
        }
        if ((privateString = matcher.group(3)) != null) {
            this.type = privateString.trim();
        }
    }

    int getOrdinal() {
        return this.ordinal;
    }

    String getName() {
        return this.name;
    }

    String getType() {
        return this.type;
    }

    public String toString() {
        return "{\n\tname: " + this.name + ",\n\tordinal: " + this.ordinal + ",\n\ttype: " + this.type + "\n}";
    }
}

