/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;
import javax.swing.event.ChangeListener;

public class MnemonicFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Mnemonic";
    private static final Color BAD_PROTOTYPE_COLOR = GThemeDefaults.Colors.Messages.ERROR;
    private static final String SHOW_UNDERLINE_FOR_REFERENCES = "Mnemonic Field.Underline Fields With References";
    private boolean underliningEnabled = true;
    protected BrowserCodeUnitFormat codeUnitFormat;
    private ChangeListener codeUnitFormatListener = e -> this.model.update();

    public MnemonicFieldFactory() {
        super(FIELD_NAME);
    }

    private MnemonicFieldFactory(FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, (Options)fieldOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Mnemonic_Field");
        fieldOptions.getOptions("Mnemonic Fields").setOptionsHelpLocation(hl);
        fieldOptions.registerOption(SHOW_UNDERLINE_FOR_REFERENCES, (Object)true, hl, "Shows an underline on mnemonic fields that have references.");
        this.underliningEnabled = fieldOptions.getBoolean(SHOW_UNDERLINE_FOR_REFERENCES, true);
        this.codeUnitFormat = new BrowserCodeUnitFormat(fieldOptions, true);
        this.codeUnitFormat.addChangeListener(this.codeUnitFormatListener);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(SHOW_UNDERLINE_FOR_REFERENCES)) {
            this.underliningEnabled = (Boolean)newValue;
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        boolean invalidInstrProto = false;
        if (cu instanceof Instruction) {
            invalidInstrProto = ((Instruction)cu).getPrototype() instanceof InvalidPrototype;
        }
        boolean underline = this.underliningEnabled && cu.getMnemonicReferences().length > 0;
        String mnemonic = this.codeUnitFormat.getMnemonicRepresentation(cu);
        Object c = ListingColors.MnemonicColors.NORMAL;
        if (invalidInstrProto) {
            c = BAD_PROTOTYPE_COLOR;
        } else if (cu instanceof Instruction) {
            Instruction instr = (Instruction)cu;
            if (instr.getFlowOverride() != FlowOverride.NONE || instr.isFallThroughOverridden()) {
                c = ListingColors.MnemonicColors.OVERRIDE;
            }
        } else {
            Data data = (Data)cu;
            if (data.isDefined() && data.getDataType().isNotYetDefined()) {
                c = GThemeDefaults.Colors.Messages.ERROR;
            }
        }
        AttributedString as = new AttributedString(mnemonic, (Color)c, this.getMetrics(), underline, (Color)ListingColors.UNDERLINE);
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        Address referenceAddress = this.getReferenceAddress(cu);
        String mnemonic = this.codeUnitFormat.getMnemonicRepresentation(cu);
        return new MnemonicFieldLocation(cu.getProgram(), cu.getMinAddress(), referenceAddress, cpath, mnemonic, col);
    }

    private Address getReferenceAddress(CodeUnit cu) {
        Reference[] referencesFrom;
        Program program = cu.getProgram();
        if (cu instanceof Data && ((Data)cu).getNumComponents() != 0) {
            return null;
        }
        ReferenceManager referenceManager = program.getReferenceManager();
        for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(cu.getMinAddress())) {
            if (!reference.isMemoryReference()) continue;
            return reference.getToAddress();
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof MnemonicFieldLocation)) {
            return null;
        }
        if (!this.hasSamePath(bf, programLoc)) {
            return null;
        }
        MnemonicFieldLocation loc = (MnemonicFieldLocation)programLoc;
        return new FieldLocation(index, fieldNum, 0, loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider hsProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new MnemonicFieldFactory(formatModel, hsProvider, (Options)displayOptions, fieldOptions);
    }
}

