/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.GetDomainObjectTask;
import ghidra.framework.main.datatree.VersionHistoryPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class OpenVersionedFileDialog<T extends DomainObject>
extends DataTreeDialog {
    private static final String SHOW_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.SHOW_HISTORY";
    private static final String HEIGHT_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.HEIGHT";
    private static final String WIDTH_NO_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.WIDTH_NO_HISTORY";
    private static final String WIDTH_WITH_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.WIDTH_WITH_HISTORY";
    private static final int DEFAULT_WIDTH_NO_HISTORY = 350;
    private static final int DEFAULT_WIDTH_WITH_HISTORY = 800;
    private static final int DIVIDER_SIZE = 2;
    private static final int PROJECT_FILES_TAB = 0;
    private static final int OPEN_OBJECT_LIST_TAB = 1;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private JButton historyButton;
    private JPanel mainPanel;
    private boolean historyIsShowing;
    private PluginTool tool;
    private VersionHistoryPanel historyPanel;
    private List<DockingActionIf> popupActions = Collections.emptyList();
    private Class<T> domainObjectClass;
    private List<T> openDomainObjects;
    private GFilterTable<T> openObjectsTable;

    public OpenVersionedFileDialog(PluginTool tool, String title, Class<T> domainObjectClass) {
        super(tool.getToolFrame(), title, 0, f -> domainObjectClass.isAssignableFrom(f.getDomainObjectClass()));
        this.tool = tool;
        this.domainObjectClass = domainObjectClass;
        this.init();
    }

    public void setOpenObjectChoices(List<T> openDomainObjects) {
        this.openDomainObjects = openDomainObjects != null && !openDomainObjects.isEmpty() ? new ArrayList<T>(openDomainObjects) : null;
    }

    public T getDomainObject(Object consumer, boolean immutable) {
        DomainFile domainFile;
        T dobj = null;
        if (this.usingOpenProgramList()) {
            dobj = this.getSelectedOpenDomainObject();
            if (dobj != null) {
                dobj.addConsumer(consumer);
            }
            return dobj;
        }
        int version = -1;
        if (this.historyPanel != null) {
            version = this.historyPanel.getSelectedVersionNumber();
        }
        if ((domainFile = this.getDomainFile()) != null) {
            GetDomainObjectTask task = new GetDomainObjectTask(consumer, domainFile, version, immutable);
            this.tool.execute((Task)task, 1000);
            return (T)task.getDomainObject();
        }
        return null;
    }

    public int getVersion() {
        if (this.historyPanel != null && !this.usingOpenProgramList()) {
            return this.historyPanel.getSelectedVersionNumber();
        }
        return -1;
    }

    @Override
    public DomainFile getDomainFile() {
        if (this.usingOpenProgramList()) {
            return null;
        }
        return super.getDomainFile();
    }

    @Override
    public DomainFolder getDomainFolder() {
        if (this.usingOpenProgramList()) {
            return null;
        }
        return super.getDomainFolder();
    }

    @Override
    protected JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)super.buildMainPanel(), "Center");
        JPanel historyButtonPanel = new JPanel(new FlowLayout(2));
        historyButtonPanel.add(this.historyButton);
        this.mainPanel.add((Component)historyButtonPanel, "South");
        this.mainPanel.setMinimumSize(new Dimension(200, 500));
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(this.mainPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(0);
        this.splitPane.setDividerLocation(1.0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel projectFilePanel = new JPanel(new BorderLayout());
        projectFilePanel.add(this.splitPane);
        String showHistory = Preferences.getProperty((String)SHOW_HISTORY_PREFERENCES_KEY, (String)Boolean.FALSE.toString(), (boolean)true);
        if (Boolean.parseBoolean(showHistory)) {
            this.showHistoryPanel(true);
        }
        this.openObjectsTable = null;
        this.tabbedPane = null;
        this.updateOkTooltip();
        if (this.openDomainObjects == null) {
            return projectFilePanel;
        }
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("Tabs");
        this.tabbedPane.add("Project Files", projectFilePanel);
        this.tabbedPane.add("Open " + this.domainObjectClass.getSimpleName() + "s", this.buildOpenObjectsTable());
        this.tabbedPane.addChangeListener(e -> {
            int selectedTabIndex = this.tabbedPane.getModel().getSelectedIndex();
            if (selectedTabIndex == 0) {
                String nameText = this.getNameText();
                this.setOkEnabled(nameText != null && !nameText.isEmpty());
            } else {
                this.setOkEnabled(this.getSelectedOpenDomainObject() != null);
            }
            this.updateOkTooltip();
        });
        JPanel tabbedPanel = new JPanel();
        tabbedPanel.setLayout(new BorderLayout());
        tabbedPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setSelectedIndex(0);
        return tabbedPanel;
    }

    private boolean usingOpenProgramList() {
        return this.tabbedPane != null && this.tabbedPane.getModel().getSelectedIndex() == 1;
    }

    private T getSelectedOpenDomainObject() {
        if (!this.usingOpenProgramList()) {
            return null;
        }
        return (T)((DomainObject)this.openObjectsTable.getSelectedRowObject());
    }

    private Component buildOpenObjectsTable() {
        this.openObjectsTable = new GFilterTable((RowObjectTableModel)new OpenObjectsTableModel());
        GTable table = this.openObjectsTable.getTable();
        table.getSelectionModel().setSelectionMode(0);
        this.openObjectsTable.addSelectionListener(e -> {
            this.setOkEnabled(true);
            this.okButton.setToolTipText("Use the selected " + this.domainObjectClass.getSimpleName());
        });
        table.addMouseListener((MouseListener)new GMouseListenerAdapter(){

            public void doubleClickTriggered(MouseEvent e) {
                if (OpenVersionedFileDialog.this.okButton.isEnabled()) {
                    OpenVersionedFileDialog.this.okCallback();
                }
            }
        });
        return this.openObjectsTable;
    }

    private void showHistoryPanel(boolean showHistory) {
        this.historyIsShowing = showHistory;
        if (showHistory) {
            this.createHistoryPanel();
            this.historyButton.setText("Hide History");
            DomainFile df = this.treePanel.getSelectedDomainFile();
            this.historyPanel.setDomainFile(df);
            this.splitPane.setDividerSize(2);
            this.splitPane.setDividerLocation(346);
        } else {
            this.historyButton.setText("Show History>>");
            this.splitPane.setDividerSize(0);
            this.splitPane.setRightComponent(null);
            this.historyPanel = null;
        }
        Dimension size = this.getPreferredSizeForHistoryState();
        this.rootPanel.setPreferredSize(size);
        this.repack();
    }

    private Dimension getPreferredSizeForHistoryState() {
        int height = Integer.parseInt(Preferences.getProperty((String)HEIGHT_PREFERENCES_KEY, (String)Integer.toString(500)));
        String key = this.historyIsShowing ? WIDTH_WITH_HISTORY_PREFERENCES_KEY : WIDTH_NO_HISTORY_PREFERENCES_KEY;
        int defaultWidth = this.historyIsShowing ? 800 : 350;
        int width = Integer.parseInt(Preferences.getProperty((String)key, (String)Integer.toString(defaultWidth)));
        return new Dimension(width, height);
    }

    private void savePreferences() {
        Dimension size = this.rootPanel.getSize();
        String propertyName = this.historyIsShowing ? WIDTH_WITH_HISTORY_PREFERENCES_KEY : WIDTH_NO_HISTORY_PREFERENCES_KEY;
        Preferences.setProperty((String)propertyName, (String)Integer.toString(size.width));
        Preferences.setProperty((String)HEIGHT_PREFERENCES_KEY, (String)Integer.toString(size.height));
        Preferences.setProperty((String)SHOW_HISTORY_PREFERENCES_KEY, (String)Boolean.toString(this.historyIsShowing));
        Preferences.store();
    }

    @Override
    public void close() {
        this.savePreferences();
        this.historyPanel = null;
        super.close();
    }

    @Override
    protected void dialogShown() {
        super.dialogShown();
        for (DockingActionIf action : this.popupActions) {
            this.addAction(action);
        }
    }

    protected void dialogClosed() {
        super.dialogClosed();
        for (DockingActionIf action : this.popupActions) {
            this.removeAction(action);
        }
    }

    private void updateOkTooltip() {
        Object tip;
        if (this.usingOpenProgramList()) {
            tip = "Use selected " + this.domainObjectClass.getSimpleName();
        } else {
            int versionNumber;
            tip = "Open the selected file";
            if (this.historyPanel != null && this.historyIsShowing && (versionNumber = this.historyPanel.getSelectedVersionNumber()) >= 0) {
                DomainFile df = OpenVersionedFileDialog.super.getDomainFile();
                this.okButton.setToolTipText("Open version " + versionNumber + " for " + df.getName());
            }
        }
        this.okButton.setToolTipText((String)tip);
    }

    private boolean createHistoryPanel() {
        try {
            this.historyPanel = new VersionHistoryPanel(this.tool, null);
            this.popupActions = this.historyPanel.createPopupActions();
        }
        catch (IOException ioe) {
            Msg.debug(this.getClass(), (Object)("Error creating history panel for versioned file: " + ioe.getMessage()), (Throwable)ioe);
            return false;
        }
        this.historyPanel.setBorder((Border)BorderFactory.createTitledBorder("Version History"));
        this.splitPane.setRightComponent((Component)this.historyPanel);
        this.historyPanel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateOkTooltip();
        });
        return true;
    }

    private void init() {
        this.historyButton = new JButton("History>>");
        this.historyButton.addActionListener(e -> this.showHistoryPanel(!this.historyIsShowing));
        this.rootPanel.setPreferredSize(this.getPreferredSizeForHistoryState());
    }

    @Override
    protected void addTreeListeners() {
        super.addTreeListeners();
        this.treePanel.addTreeSelectionListener(e -> {
            if (this.historyPanel != null) {
                DomainFile df = this.treePanel.getSelectedDomainFile();
                this.historyPanel.setDomainFile(df);
            }
            this.updateOkTooltip();
        });
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        ActionContext context = super.getActionContext(event);
        if (context != null) {
            return context;
        }
        ActionContext actionContext = new ActionContext(null, (Object)this, event.getComponent());
        actionContext.setMouseEvent(event);
        return actionContext;
    }

    private class OpenObjectsTableModel
    extends AbstractGTableModel<T> {
        private OpenObjectsTableModel() {
        }

        public String getName() {
            return "Open DomainObject List";
        }

        public List<T> getModelData() {
            return OpenVersionedFileDialog.this.openDomainObjects;
        }

        public Object getColumnValueForRow(T t, int columnIndex) {
            return t.getDomainFile().toString();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int columnIndex) {
            return "Program Path";
        }

        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

